<?php namespace Visiosoft\CustomfieldsModule\CustomField;


use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\CustomfieldsModule\CustomField\Command\getFieldsByAd;

class CustomFieldApiCollection extends CustomFieldRepository
{
    use DispatchesJobs;

    public function getCustomfieldsByAd(array $params)
    {
        $this->dispatch(new CheckRequiredParams(['ad_id'],$params));

        $ad = $this->checkAd($params['ad_id']);

        $customfields = $this->dispatch(new getFieldsByAd($ad->id));

        return $customfields;
    }

    public function checkAd($id)
    {
        $ad_model = new AdvModel();

        if (!$ad = $ad_model->newQuery()->find($id)) {
            throw new \Exception(trans('visiosoft.module.advs::message.ad_doesnt_exist'), 404);
            die;
        }
        return $ad;
    }
}
