<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Http\Request;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\CustomfieldsModule\CustomField\Form\CustomFieldFormBuilder;
use Visiosoft\CustomfieldsModule\CustomField\Table\CustomFieldTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CustomfieldsModule\CustomField\Table\Filter\CategoryFilterQuery;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;

class CustomFieldsController extends AdminController
{
    /**
     * @var ParentModel
     */
    public $parent_model;

    /**
     * @var CategoryModel
     */
    public $category_model;

    /**
     * @var CustomFieldModel
     */
    public $model;

    /**
     * @var CustomFieldRepositoryInterface
     */
    public $customfield_repository;

    /**
     * @var CfvalueRepositoryInterface
     */
    public $CFValue_repository;
    /**
     * @var CustomFieldAdvRepositoryInterface
     */
    public $customfieldAdv_repository;
    /**
     * @var ParentRepositoryInterface
     */
    public $Parent_Repository;

    /**
     * CustomFieldsController constructor.
     * @param ParentModel $parent_model
     * @param CategoryModel $category_model
     * @param CustomFieldModel $model
     */
    public function __construct(
        ParentModel $parent_model,
        CategoryModel $category_model,
        CustomFieldModel $model,
        CustomFieldRepositoryInterface $customFieldRepository,
        CfvalueRepositoryInterface $cfvalueRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
        ParentRepositoryInterface $parentRepository
    )
    {
        $this->parent_model = $parent_model;
        $this->category_model = $category_model;
        $this->customfield_repository = $customFieldRepository;
        $this->customfieldAdv_repository = $customFieldAdvRepository;
        $this->CFValue_repository = $cfvalueRepository;
        $this->Parent_Repository = $parentRepository;
        $this->model = $model;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CustomFieldTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomFieldTableBuilder $table)
    {
        if ($this->request->action == "delete") {
            $id_list = $this->request->id;
            foreach ($id_list as $item) {
                $this->customfield_repository->deleteCF($item);
                $this->CFValue_repository->deleteByCF($item);
                $this->customfieldAdv_repository->deleteByCF($item);
                $this->Parent_Repository->deleteByCF($item);
            }

            $this->messages->success(trans('streams::message.delete_success', ['count' => count($id_list)]));
            return $this->redirect->to('/admin/customfields');
        }

        $table->setColumns([
            'parent_category' =>
                [
                    'value' => function (EntryInterface $entry) {
                        $parents = $this->parent_model->where('cf_id', $entry->id)->get()->pluck('cat_id');
                        $categoryName = array();
                        foreach ($parents as $parent) {
                            $category = $this->category_model->getCat($parent);
                            if ($category)
                                $categoryName[] = $category->name;
                        }
                        if (count($categoryName))
                            return implode(',', $categoryName);
                        else
                            return trans('visiosoft.module.customfields::field.all_categories.name');
                    }
                ],
            'name', 'type']);
        $table->setFilters([
            'cat_id' => [
                'exact' => true,
                'placeholder' => trans('visiosoft.module.customfields::field.all_categories.name'),
                'filter' => 'select',
                'query' => CategoryFilterQuery::class,
                'options' => function () {
                    $options = [];
                    foreach ($this->parent_model->get() as $item) {
                        if (!isset($options[$item->cat_id])) {
                            $category = $this->category_model->getCat($item->cat_id);
//                            dd($item->cat_id,$category);
                            if (!is_null($category))
                                $options[$category->id] = $category->name . " ";
                        }
                    }
                    return $options;

                }
            ], 'type' => [
                'exact' => true,
                'filter' => 'select',
                'options' => function () {
                    return [
                        "checkboxes" => "checkboxes",
                        "decimal" => "decimal",
                        "integer" => "integer",
                        "radio" => "radio",
                        "range" => "range",
                        "select" => "select",
                        "selectdropdown" => "select dropdown",
                        "selecttop" => "select top",
                        "selectrange" => "select range",
                        "selectimage" => "select image",
                        "text" => "text",
                    ];
                }
            ],
        ]);
        return $table->render();
    }


    public function create(CustomFieldFormBuilder $form, Request $request)
    {
        return $form->render();
    }

    public function edit(CustomFieldFormBuilder $form, Request $request, $id)
    {
        return $form->render($id);
    }
}
