<?php namespace Visiosoft\CustomfieldsModule\CustomField\Form;

use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;

class CustomFieldFormHandler
{
    public function handle(CustomFieldFormBuilder $builder, ParentRepositoryInterface $parentRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $builder->saveForm();
        $entry = $builder->getFormEntry();

        if (request('action') == "save") {
            if ($categories = request('parent_category')) {
                foreach ($categories as $category) {
                    $parentRepository->createNew($entry->getId(), $category);
                }
            }
        } elseif (request('action') == "update") {
            //Remove old
            $parentRepository->deleteByCF($entry->getId());

            if ($categories = request('parent_category')) {
                foreach ($categories as $category) {
                    $parentRepository->createNew($entry->getId(), $category);
                }
            }
        }
    }
}
