<?php namespace Visiosoft\CustomfieldsModule\CustomField\Form;

class CustomFieldFormFields
{
    public function handle(CustomFieldFormBuilder $builder)
    {
        if ($builder->getFormMode() == "edit") {
            $fields = ['name', 'description', 'required', 'seenList'];

        } else {
            $fields = [
                'name' => [
                    'translatable' => true,
                    'required' => true,
                ],
                'slug',
                'description',
                'required',
                'seenList',
            ];

            $customfieldType = [
                "checkboxes" => trans("visiosoft.module.customfields::field.checkboxes_type"),
                "decimal" => trans("visiosoft.module.customfields::field.decimal_type"),
                "integer" => trans("visiosoft.module.customfields::field.integer_type"),
                "radio" => trans("visiosoft.module.customfields::field.radio_type"),
                "range" => trans("visiosoft.module.customfields::field.range_type"),
                "select" => trans("visiosoft.module.customfields::field.select_type"),
                "selectdropdown" => trans("visiosoft.module.customfields::field.selectdropdown_type"),
                "selecttop" => trans("visiosoft.module.customfields::field.selecttop_type"),
                "selectrange" => trans("visiosoft.module.customfields::field.selectrange_type"),
                "selectimage" => trans("visiosoft.module.customfields::field.selectimage_type"),
                "text" => trans("visiosoft.module.customfields::field.text_type"),
            ];

            $fields = array_merge([
                'type' => [
                    'instructions' => function () {
                        $message = '<div class="alert alert-info alert-dismissible"><ul class="list-unstyled">';
                        foreach (trans('visiosoft.module.customfields::message.field_type.instructions') as $key => $item) {
                            $message .= "<li><b>" . trans('visiosoft.module.customfields::field.' . $key . '_type') . ":</b> " . $item . "</li>";
                        }
                        $message .= "</ul></div>";
                        return $message;
                    },
                    'config' => [
                        'required' => true,
                        'mode' => 'search',
                        'options' => $customfieldType
                    ]
                ],
            ], $fields);
        }

        $builder->setFields($fields);
    }
}
