<?php namespace Visiosoft\CustomfieldsModule\CustomField;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CustomFieldRepository extends EntryRepository implements CustomFieldRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CustomFieldModel
     */
    protected $model;
    protected $ad;

    /**
     * Create a new CustomFieldRepository instance.
     *
     * @param CustomFieldModel $model
     */
    public function __construct(CustomFieldModel $model, AdvModel $ad)
    {
        $this->model = $model;
        $this->ad = $ad;
    }

    /**
     * @param $slug
     * @return mixed
     */
    public function findBySlug($slug)
    {
        return $this->model->where('slug', $slug)->first();
    }

    /**
     * @param $id
     * @return mixed
     */
    public function deleteCF($id)
    {
        return $this->model->find($id)->delete();
    }

    public function getAdValueByCustomFieldSlug($slug, $ad_id)
    {
        $cf_field = $this->findBySlug($slug);
        $ad = $this->ad->isAdv($ad_id);

        if ($cf_field and $ad) {
            $cf_json_row = json_decode($ad->cf_json, true);
            if (is_array($cf_json_row) and array_key_exists('cf' . $cf_field->id, $cf_json_row)) {
                return $cf_json_row['cf' . $cf_field->id];
            }
        }
        return null;
    }
}
