<?php namespace Visiosoft\CustomfieldsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\CustomField\Command\getCustomFields;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;

class CustomfieldsModulePlugin extends Plugin
{

	public $repository;

	public function __construct(CustomFieldRepositoryInterface $repository)
	{
		$this->repository = $repository;
	}

	/**
	 * @return array
	 */
	public function getFunctions()
	{
		return [
			new \Twig_SimpleFunction(
				'getSelectedCategory',
				function ($id) {
					$categoryModel = new CategoryModel();
					$parentModel = new ParentModel();
					$categories = $parentModel->where('cf_id', $id)->get()->pluck('cat_id');
					$new_categories = array();
					foreach ($categories as $category) {
						if ($cat = $categoryModel->getCat($category)) {
							$parents = $cat->getParentCats($cat->id, null);
							krsort($parents);
							$name = "";
							foreach ($parents as $key => $parent) {
								$name .= ($key == 0) ? $parent . '' : $parent . ' > ';
							}
							$new_categories[] = [$category => $name];
						}
					}
					return json_encode($new_categories);
				}
			),
			new \Twig_SimpleFunction(
				'getCustomField',
				function ($slug, $placeholder = 'visiosoft.module.customfields::field.select.name') {
					if (!is_null($cf = $this->dispatch(new getCustomFields($slug, $placeholder)))) {
						return $cf;
					}
					return null;
				}
			),
			new \Twig_SimpleFunction(
				'unset',
				function ($variable, $array, $withValue = false) {
					if ($withValue) {
						if (($key = array_search($variable, $array)) !== false) {
							unset($array[$key]);
						}
					} else {
						unset($array[$variable]);
					}
					return $array;
				}
			),
			new \Twig_SimpleFunction(
				'getValueWithSlugAndAd',
				function ($slug, $ad_id) {
					if (!is_null($cf = $this->repository->getAdValueByCustomFieldSlug($slug, $ad_id))) {
						return $cf;
					}
					return null;
				}
			),
		];
	}
}
