<?php namespace Visiosoft\CustomfieldsModule\CustomField;

use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldInterface;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCustomFieldsEntryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CustomFieldModel extends CustomfieldsCustomFieldsEntryModel implements CustomFieldInterface
{
    /**
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection
     */
    public function selectableType()
    {
        $customfields = $this->query()->where('type', 'select')
            ->orWhere('type', 'checkboxes')
            ->orWhere('type', 'selecttop')
            ->get();
        return $customfields;
    }

    /**
     * @return HasMany
     */
    public function cfvalues()
    {
        return $this->hasMany(CfvalueModel::class, 'custom_field_id');
    }

    /**
     * @param null $id
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Query\Builder[]|\Illuminate\Support\Collection
     */
    public function getCustomfieldsJoinCategoryWithCategoryID($id = null)
    {
        return $this->customfieldsJoinCategoryWithCategoryID($id)->get();
    }

    /**
     * @param null $id
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Query\Builder
     */
    public function customfieldsJoinCategoryWithCategoryID($id = null)
    {
        $query = $this->query()->leftJoin('customfields_parent', function ($join) {
            $join->on('customfields_custom_fields.id', '=', 'customfields_parent.cf_id');
        });

        $query = $query->selectRaw("default_customfields_custom_fields.*, 
        default_customfields_parent.cat_id as cat_id");

        if ($id != null)
            return $query->where('cat_id', $id);
        else
            return $query;

    }
}
