<?php namespace Visiosoft\CustomfieldsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Anomaly\Streams\Platform\Addon\FieldType\FieldType;

class cfController extends PublicController
{
    public function index($mainCats, $subCats)
    {
        $checkboxes = array();
        $textfields = array();
        $topfields = array();
        $ranges = array();

        $findcustomfields = CustomfieldModel::query()->whereNull('parent_category')->get();

        if($findcustomfields){
            foreach ($findcustomfields as $findcustomfield) {
                if($findcustomfield->type!='checkboxes'){
                    $cfcheckbox = array();
                    $field_type = new FieldType;
                    $cfcheckbox['id'] = $findcustomfield->id;
                    $cfcheckbox['name'] = $findcustomfield->name;
                    if($findcustomfield->type == 'range'){
                        $ranges[] = $cfcheckbox;
                    }else{
                        if ($findcustomfield->cfvalues()->count() > 0) {
                            $values = array();
                            foreach ($findcustomfield->cfvalues as $v) {
                                $cfcheckbox['values'][$v->id] = $v->custom_field_value;
                            }
                            if($findcustomfield->type=="selecttop"){
                                if(count($topfields)<1){
                                    $topfields[] = $cfcheckbox;
                                }
                            }else{
                                $checkboxes[] = $cfcheckbox;
                            }
                        }
                    }
                }
            }
        }

        foreach ($mainCats as $mainCat) {
            $findcustomfields = CustomfieldModel::query()->where('parent_category', $mainCat->id)->get();
            foreach ($findcustomfields as $findcustomfield) {
                if($findcustomfield->type!='checkboxes'){
                    $cfcheckbox = array();
                    $field_type = new FieldType;
                    $cfcheckbox['id'] = $findcustomfield->id;
                    $cfcheckbox['name'] = $findcustomfield->name;
                    if($findcustomfield->type == 'range'){
                        $ranges[] = $cfcheckbox;
                    }else{
                        if ($findcustomfield->cfvalues()->count() > 0) {
                            $values = array();
                            foreach ($findcustomfield->cfvalues as $v) {
                                $cfcheckbox['values'][$v->id] = $v->custom_field_value;
                            }
                            if($findcustomfield->type=="selecttop"){
                                if(count($topfields)<1 && count($subCats)>0){
                                    $topfields[] = $cfcheckbox;
                                }
                            }else{
                                $checkboxes[] = $cfcheckbox;
                            }
                        }
                    }
                }
            }
        }

        if (count($subCats) > 0) {
            foreach ($subCats as $mainCat) {
                $findcustomfields = CustomfieldModel::query()->where('parent_category', $mainCat->id)->get();
                foreach ($findcustomfields as $findcustomfield) {
                    $cfcheckbox = array();
                    $field_type = new FieldType;
                    $cfcheckbox['id'] = $findcustomfield->id;
                    $cfcheckbox['name'] = $findcustomfield->name;
                    if($findcustomfield->type == 'range'){
                        $ranges[] = $cfcheckbox;
                    }else{
                        if ($findcustomfield->cfvalues()->count() > 0) {
                            $values = array();
                            foreach ($findcustomfield->cfvalues as $v) {
                                $cfcheckbox['values'][$v->id] = $v->custom_field_value;
                            }
                            if($findcustomfield->type=="selecttop"){
                                if(count($topfields)<1){
                                    $topfields[] = $cfcheckbox;
                                }
                            }else{
                                $checkboxes[] = $cfcheckbox;
                            }
                        }
                    }
                }
            }
        }
        return $returns = array('checkboxes' => $checkboxes, 'topfields' => $topfields, 'textfields' => $textfields, 'ranges' => $ranges);
    }
    public function indexseen($ad, $cat, $advs, $index)
    {
        $seenList = array();
        $findcustomfields = CustomfieldModel::query()->where('parent_category', $cat)->where('seenList', 1)->get();
        foreach ($findcustomfields as $listseencs) {
            $cfcode = 'cf' . $listseencs->id;
            $cf_json_array = json_decode($ad->cf_json, true);
            if (count($cf_json_array) > 0 && isset($cf_json_array[$cfcode])) {
                $advs[$index]->$cfcode = $cf_json_array[$cfcode];
            } else {
                $advs[$index]->$cfcode = '';
            }
            $seenList[$cfcode] = $listseencs->name;
        }
        return $returns = array('seenList' => $seenList, 'advs' => $advs);
    }
    public function view($adv)
    {
        $cf_array = json_decode($adv['cf_json'], true);
        $features = array();
        $findcustomfields = $adv->customfields;
        foreach ($findcustomfields as $fcf) {
            if($fcf->customfield){
                if ($fcf->customfield->cfvalues()->count() > 0 && is_array($cf_array['cf' . $fcf->customfield->id])) {
                    $customfieldsmulti = array();

                    foreach($fcf->customfield->cfvalues as $allcfval){

                        if(in_array($allcfval->id, $cf_array['cf' . $fcf->customfield->id])){
                            $customfieldsmulti[$allcfval->id] = ['val' => $allcfval->custom_field_value, 'status' => 1];
                        }else{
                            $customfieldsmulti[$allcfval->id] = ['val' => $allcfval->custom_field_value, 'status' => 0];
                        }
                    }





                    // foreach ($cf_array['cf' . $fcf->customfield->id] as $vv) {




                    //     $customfieldsmulti[] = $fcf->customfield->cfvalues()->find($vv)->custom_field_value;


                    //     // if($vv == $cf_array['cf'.$fcf->customfield->id]){
                    //     // $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $fcf->customfield->cfvalues()->find($vv)->custom_field_value];
                    //     // }
                    // }
                    $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $customfieldsmulti];
                } else if ($fcf->customfield->cfvalues()->count() > 0) {
                    $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $fcf->customfield->cfvalues()->find($cf_array['cf' . $fcf->customfield->id])->custom_field_value];
                } else {
                    $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $cf_array['cf' . $fcf->customfield->id]];
                }
            }
        }

        return $features;
    }
    public function create($categories)
    {
        foreach ($categories as $category) {
            if ($cats[$category] != 0) {
                $findcustomfields = CustomfieldModel::query()->where('parent_category', $cats[$category])->get();

                foreach ($findcustomfields as $findcustomfield) {
                    $field_type = new FieldType;
                    // $field_type->setField('cf__'.$findcustomfield->translations->first()->name);
                    $field_type->setField('cf__' . $findcustomfield->slug);
                    if ($findcustomfield->cfvalues()->count() > 0) {
                        $values = array();
                        foreach ($findcustomfield->cfvalues as $v) {
                            $values[$v->id] = $v->custom_field_value;
                        }
                        $field_type->options = $values;
                        if ($findcustomfield->type == 'select' || $findcustomfield->type == 'selecttop') {
                            if (view()->exists('anomaly.field_type.select::dropdown')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.select::dropdown')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        } else if ($findcustomfield->type == 'checkboxes') {
                            if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        } else if ($findcustomfield->type == 'radio') {
                            if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::radio')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::radio')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        }
                    } else {
                        if($findcustomfield->type=='range'){
                            $findtype = "integer";
                        }else{
                            $findtype = $findcustomfield->type;
                        }
                        $view = 'anomaly.field_type.' . $findtype . '::input';
                        if (view()->exists($view)) {
                            $custom_fields[] = ['custom_field_input' => view($view)->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                        }
                    }
                }
            }
        }
        return $custom_fields;
    }
    public function edit($adv, $categories, $cats)
    {
        $custom_fields = array();
        $cf_array = json_decode($adv['cf_json'], true);
        if (!is_array($cf_array)) {
            $cf_array = array();
        }


        $findcustomfields = CustomfieldModel::query()->whereNull('parent_category')->get();

        foreach ($findcustomfields as $findcustomfield) {
            $field_type = new FieldType;
            // $field_type->setField('cf__'.$findcustomfield->translations->first()->name);
            $field_type->setField('cf__' . $findcustomfield->slug);
            if (array_key_exists('cf' . $findcustomfield->id, $cf_array)) {
                $field_type->setValue($cf_array['cf' . $findcustomfield->id]);
                $field_type->key = $cf_array['cf' . $findcustomfield->id];
            }
            if ($findcustomfield->cfvalues()->count() > 0) {
                $values = array();
                foreach ($findcustomfield->cfvalues as $v) {
                    $values[$v->id] = $v->custom_field_value;
                }
                $field_type->options = $values;
                if ($findcustomfield->type == 'select'||$findcustomfield->type == 'selecttop') {
                    if (view()->exists('anomaly.field_type.select::dropdown')) {
                        $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.select::dropdown')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                    }
                } else if ($findcustomfield->type == 'checkboxes') {
                    if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')) {
                        $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                    }
                } else if ($findcustomfield->type == 'radio') {
                    if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::radio')) {
                        $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::radio')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                    }
                }
            } else {
                if($findcustomfield->type=='range'){
                    $findtype = "integer";
                }else{
                    $findtype = $findcustomfield->type;
                }
                $view = 'anomaly.field_type.' . $findtype . '::input';
                if (view()->exists($view)) {
                    $custom_fields[] = ['custom_field_input' => view($view)->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                }
            }
        }






        foreach ($categories as $category) {

            if ($cats[$category] != 0) {
                $findcustomfields = CustomfieldModel::query()->where('parent_category', $cats[$category])->get();
                foreach ($findcustomfields as $findcustomfield) {
                    $field_type = new FieldType;
                    // $field_type->setField('cf__'.$findcustomfield->translations->first()->name);
                    $field_type->setField('cf__' . $findcustomfield->slug);
                    if (array_key_exists('cf' . $findcustomfield->id, $cf_array)) {
                        $field_type->setValue($cf_array['cf' . $findcustomfield->id]);
                        $field_type->key = $cf_array['cf' . $findcustomfield->id];
                    }
                    if ($findcustomfield->cfvalues()->count() > 0) {
                        $values = array();
                        foreach ($findcustomfield->cfvalues as $v) {
                            $values[$v->id] = $v->custom_field_value;
                        }
                        $field_type->options = $values;
                        if ($findcustomfield->type == 'select'||$findcustomfield->type == 'selecttop') {
                            if (view()->exists('anomaly.field_type.select::dropdown')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.select::dropdown')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        } else if ($findcustomfield->type == 'checkboxes') {
                            if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        } else if ($findcustomfield->type == 'radio') {
                            if (view()->exists('visiosoft.field_type.radio::radio')) {
                                $custom_fields[] = ['custom_field_input' => view('visiosoft.field_type.radio::radio')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        }
                    } else {
                        if($findcustomfield->type=='range'){
                            $findtype = "integer";
                        }else{
                            $findtype = $findcustomfield->type;
                        }
                        $view = 'anomaly.field_type.' . $findtype . '::input';
                        if (view()->exists($view)) {
                            $custom_fields[] = ['custom_field_input' => view($view)->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                        }
                    }
                }
            }
        }
        return $custom_fields;
    }
}