<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Http\Request;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\CustomfieldsModule\CustomField\Form\CustomFieldFormBuilder;
use Visiosoft\CustomfieldsModule\CustomField\Table\CustomFieldTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;

class CustomFieldsController extends AdminController
{
    /**
     * @var ParentModel
     */
    public $parent_model;

    /**
     * @var CategoryModel
     */
    public $category_model;

    /**
     * @var CustomFieldModel
     */
    public $model;

    /**
     * @var CustomFieldRepositoryInterface
     */
    public $customfield_repository;

    /**
     * CustomFieldsController constructor.
     * @param ParentModel $parent_model
     * @param CategoryModel $category_model
     * @param CustomFieldModel $model
     */
    public function __construct(
        ParentModel $parent_model,
        CategoryModel $category_model,
        CustomFieldModel $model,
        CustomFieldRepositoryInterface $customFieldRepository
    )
    {
        $this->parent_model = $parent_model;
        $this->category_model = $category_model;
        $this->customfield_repository = $customFieldRepository;
        $this->model = $model;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CustomFieldTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomFieldTableBuilder $table)
    {
        $table->setColumns([
            'parent_category' =>
                [
                    'value' => function (EntryInterface $entry) {
                        $parents = $this->parent_model->where('cf_id', $entry->id)->get()->pluck('cat_id');
                        $categoryName = array();
                        foreach ($parents as $parent) {
                            $category = $this->category_model->getCat($parent);
                            if ($category)
                                $categoryName[] = $category->name;
                        }
                        if (count($categoryName))
                            return implode(',', $categoryName);
                        else
                            return trans('visiosoft.module.customfields::field.all_categories.name');
                    }
                ],
            'name', 'type']);
        $table->setFilters([
            'cat_id' => [
                'placeholder' => 'Category',
                'filter' => 'select',
                'options' => function () {
                    $options = [];
                    foreach ($this->parent_model->get() as $item) {
                        if (!isset($options[$item->cat_id])) {
                            $category = $this->category_model->getCat($item->cat_id);
                            if (!is_null($category))
                                $options[$item->cat_id] = $category->name;
                        }
                    }
                    return $options;

                }
            ], 'type'
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CustomFieldFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CustomFieldFormBuilder $form, Request $request)
    {
        if ($request->action == "save") {
            $all = $request->all();

            if (!is_null($this->customfield_repository->findBySlug($request->slug))) {
                $this->messages->error(trans('streams::validation.unique', ['attribute' => "[Slug] <b>" . $request->slug . "</b>"]));
                return back();
            }

            $trans = preg_grep('/^name/i', array_keys($all));

            $langs = array();
            foreach ($trans as $key => $lang) {
                $langs[] = preg_replace('/^' . preg_quote('name_', '/') . '/', '', $lang);
            }

            $save_fields = array();
            foreach ($langs as $lang) {
                $save_fields[$lang] = [
                    'name' => $all['name_' . $lang],
                    'description' => $all['description_' . $lang],
                ];
            }
            $save_fields['type'] = $all['type'];

            if (isset($request->seenList))
                $save_fields['seenList'] = 1;

            $cf_saved = $this->model->create($save_fields);

            $categories = $request->parent_category;
            $this->parent_model->create([
                'cf_id' => $cf_saved->id,
                'cat_id' => $categories
            ]);
//            if ($categories != null) {
//                foreach ($categories as $category) {
//                    $this->parent_model->create([
//                        'cf_id' => $cf_saved->id,
//                        'cat_id' => $category
//                    ]);
//                }
//            }

            $this->messages->success(trans('streams::message.create_success', ['name' => trans('visiosoft.module.customfields::addon.title')]));
            return redirect('/admin/customfields');
            die;

        }

        $customfieldType = [];
        $fields = $form->getFields();

        // foreach ($fieldTypes as $fieldType) {
        //     $customfieldType[$fieldType->slug] = $fieldType->slug;
        // }

        $customfieldType = [
            "checkboxes" => "checkboxes",
            "decimal" => "decimal",
            "integer" => "integer",
            "radio" => "radio",
            "range" => "range",
            "select" => "select",
            "selecttop" => "selecttop",
            "tags" => "tags",
            "text" => "text",
            "textarea" => "textarea",
            "url" => "url",
            "wysiwyg" => "wysiwyg"
        ];

        $fields = array_merge([
            'parent_category',
            'type' => [
                'config' => [
                    'options' => $customfieldType
                ]
            ],
        ], $fields);
        $form->setFields($fields);
        $form->setActions(['save']);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CustomFieldFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CustomFieldFormBuilder $form, Request $request, $id)
    {
        if ($request->action == "update") {

            $this->parent_model->where('cf_id', $id)->delete();
            $categories = $request->parent_category;

            if ($categories) {
                foreach ($categories as $category) {
                    $this->parent_model->create([
                        'cf_id' => $id,
                        'cat_id' => $category
                    ]);
                }
            }

            $all = $request->all();
            $trans = preg_grep('/^name/i', array_keys($all));

            $langs = array();
            foreach ($trans as $key => $lang) {
                $langs[] = preg_replace('/^' . preg_quote('name_', '/') . '/', '', $lang);
            }

            $save_fields = array();
            foreach ($langs as $lang) {
                $save_fields[$lang] = [
                    'name' => $all['name_' . $lang],
                    'description' => $all['description_' . $lang],
                ];
            }

            if (isset($request->seenList))
                $save_fields['seenList'] = 1;

            $this->model->find($id)->update($save_fields);

            $this->messages->success(trans('streams::message.edit_success', ['name' => trans('visiosoft.module.customfields::addon.title')]));
            return redirect('/admin/customfields');
            die;
        }

        $form->setActions(['update']);
        $form->setFields([
            'name', 'description', 'seenList'
        ]);

        $form->setOptions(['redirect' => '/admin/customfields']);

        return $form->render($id);
    }
}
