<?php namespace Visiosoft\CustomfieldsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;

class CustomfieldsModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getSelectedCategory',
                function ($id) {
                    $categoryModel = new CategoryModel();
                    $parentModel = new ParentModel();
                    $categories = $parentModel->where('cf_id', $id)->get()->pluck('cat_id');
                    $new_categories = array();
                    foreach ($categories as $category) {
                        $new_categories[] = [$category => $categoryModel->getCat($category)->name];
                    }

                    return json_encode($new_categories);
                }
            )
        ];
    }
}
