<?php namespace Visiosoft\CustomfieldsModule\CustomField;

use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldInterface;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCustomFieldsEntryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CustomFieldModel extends CustomfieldsCustomFieldsEntryModel implements CustomFieldInterface
{
    public function selectableType() {
        $customfields = $this->query()->where('type', 'select')
            ->orWhere('type', 'checkboxes')
            ->orWhere('type', 'selecttop')
            ->get();
        return $customfields;
    }
    public function cfvalues(){
        return $this->hasMany(CfvalueModel::class, 'custom_field_id');
    }
}
