<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Visiosoft\CustomfieldsModule\Cfvalue\Form\CfvalueFormBuilder;
use Visiosoft\CustomfieldsModule\Cfvalue\Table\CfvalueTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;

class CfvalueController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CfvalueTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CfvalueTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CfvalueFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CfvalueFormBuilder $form, CustomFieldModel $customfields)
    {
        $customfieldType = [];
        $fields = $form->getFields();
        // dd($form->getFields());
        foreach($customfields->selectableType() as $customfield){
            $customfieldType[$customfield->id] = $customfield->slug;
        }
        $fields = array_merge([
                'custom_field' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => $customfieldType,
                    ],
                ]
            ], $fields);
        $form->setFields($fields);
        // $form->addRules('custom_field', [
        //     "required" => true
        // ]);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CfvalueFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CfvalueFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
