<?php namespace Visiosoft\CustomfieldsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\ParentRepository;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsParentEntryModel;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueRepository;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCfvalueEntryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\CustomFieldAdvRepository;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCustomFieldAdvsEntryModel;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\CustomFieldAdvModel;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldRepository;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCustomFieldsEntryModel;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Illuminate\Routing\Router;

class CustomfieldsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        CustomfieldsModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/customfields/cfvalue'           => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CfvalueController@index',
        'admin/customfields/cfvalue/create'    => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CfvalueController@create',
        'admin/customfields/cfvalue/edit/{id}' => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CfvalueController@edit',
        'admin/customfields/custom_field_advs'           => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CustomFieldAdvsController@index',
        'admin/customfields/custom_field_advs/create'    => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CustomFieldAdvsController@create',
        'admin/customfields/custom_field_advs/edit/{id}' => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CustomFieldAdvsController@edit',
        'admin/customfields'           => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CustomFieldsController@index',
        'admin/customfields/create'    => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CustomFieldsController@create',
        'admin/customfields/edit/{id}' => 'Visiosoft\CustomfieldsModule\Http\Controller\Admin\CustomFieldsController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\CustomfieldsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\CustomfieldsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\CustomfieldsModule\Event\ExampleEvent::class => [
        //    Visiosoft\CustomfieldsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\CustomfieldsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CustomfieldsParentEntryModel::class => ParentModel::class,
        CustomfieldsCfvalueEntryModel::class => CfvalueModel::class,
        CustomfieldsCustomFieldAdvsEntryModel::class => CustomFieldAdvModel::class,
        CustomfieldsCustomFieldsEntryModel::class => CustomFieldModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ParentRepositoryInterface::class => ParentRepository::class,
        CfvalueRepositoryInterface::class => CfvalueRepository::class,
        CustomFieldAdvRepositoryInterface::class => CustomFieldAdvRepository::class,
        CustomFieldRepositoryInterface::class => CustomFieldRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }


}
