<?php namespace Visiosoft\CustomfieldsModule\CustomField\Table;

use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Table\Filter\CategoryFilterQuery;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;

class CustomFieldTableFilters
{
    public function handle(CustomFieldTableBuilder $builder)
    {
        $builder->setFilters([
            'cat_id' => [
                'exact' => true,
                'placeholder' => trans('visiosoft.module.customfields::field.all_categories.name'),
                'filter' => 'select',
                'query' => CategoryFilterQuery::class,
                'options' => function (ParentRepositoryInterface $parentRepository,
                                       CategoryRepositoryInterface $categoryRepository) {
                    $options = [];
                    foreach ($parentRepository->newQuery()->get() as $item) {
                        if (!isset($options[$item->cat_id])) {
                            if ($category = $categoryRepository->find($item->cat_id))
                                $options[$category->id] = $category->name . " ";
                        }
                    }
                    return $options;
                }
            ], 'type' => [
                'exact' => true,
                'filter' => 'select',
                'options' => function () {
                    return [
                        "checkboxes" => "checkboxes",
                        "decimal" => "decimal",
                        "integer" => "integer",
                        "radio" => "radio",
                        "range" => "range",
                        "select" => "select",
                        "selectdropdown" => "select dropdown",
                        "selecttop" => "select top",
                        "selectrange" => "select range",
                        "selectimage" => "select image",
                        "text" => "text",
                    ];
                }
            ],
        ]);
    }
}
