$(document).ready(function () {
    var selected;

    $("select[name='parent_category[]']").select2({
        ajax: {
            url: search_category_url,
            type: "GET",
            data: function (params) {
                if ($(this).val() != null)
                    selected = $(this).val().join("-")
                return {
                    q: params.term, // search term
                    selected: selected
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data.category, function (item) {
                        return {
                            text: item.parents,
                            id: item.id
                        }
                    })
                };
            },
            cache: true
        },
        allowClear: true,
        theme: "classic",
        placeholder: "All",
        minimumInputLength: 3
    });


    if(window.location.pathname != "/admin/customfields/create")
    {
        jsonArray = JSON.parse(selected_category.replace(/&quot;/g, '"'));
        $('#parentCat').html(convertObjectToSelectOptions(jsonArray)).trigger('change');
    }
});




function convertObjectToSelectOptions(values) {
    var htmlTags = '';
    $.each(values, function (index, obj) {
        for (var tag in obj) {
            htmlTags += '<option value="' + tag + '" selected="selected">' + obj[tag] + '</option>';
        }
    });

    return htmlTags;
}