<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Form\CfvalueFormBuilder;
use Visiosoft\CustomfieldsModule\Cfvalue\Table\CfvalueTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;

class CfvalueController extends AdminController
{
    /**
     * @var ParentRepositoryInterface
     */
    private $parent;

    /**
     * @var CategoryModel
     */
    private $category;

    /**
     * @var CfvalueModel
     */
    private $model;
    /**
     * @var CustomFieldAdvRepositoryInterface
     */
    private $CFAdv_Repository;

    /**
     * CfvalueController constructor.
     * @param ParentRepositoryInterface $parentRepository
     * @param CategoryModel $categoryModel
     */
    public function __construct(
        ParentRepositoryInterface $parentRepository,
        CategoryModel $categoryModel,
        CfvalueModel $cfvalueModel,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository
    )
    {
        $this->parent = $parentRepository;
        $this->category = $categoryModel;
        $this->model = $cfvalueModel;
        $this->CFAdv_Repository = $customFieldAdvRepository;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CfvalueTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CfvalueTableBuilder $table)
    {
        if ($this->request->action == "delete") {
            $id_list = $this->request->id;
            foreach ($id_list as $item) {
                $cfValue = $this->model->find($item);
                $this->CFAdv_Repository->deleteByCFValue($cfValue->custom_field_id, $item);
                $cfValue->delete();
            }

            $this->messages->success(trans('streams::message.delete_success', ['count' => count($id_list)]));
            return $this->redirect->to('/admin/customfields/cfvalue');
        }

        $table->setColumns([
            'custom_field',
            'category' => [
                'value' => function (EntryInterface $entry) {
                    $categories = $this->getParentCategories($entry->custom_field_id);
                    if (count($categories)) {
                        $categories_name = array();
                        foreach ($categories as $category) {
                            $categories_name[] = $category->name;
                        }
                        return implode(',', $categories_name);
                    } else
                        //All Category
                        return trans('visiosoft.module.customfields::field.all');
                }
            ],
            'custom_field_value'
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CfvalueFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CfvalueFormBuilder $form, CustomFieldModel $customfields)
    {
        $customfieldType = [];
        $fields = $form->getFields();

        foreach ($customfields->selectableType() as $customfield) {
            $categories = $this->getParentCategories($customfield->id);

            //Add Categories Name
            if (count($categories)) {
                $categories_name = array();
                foreach ($categories as $category) {
                    $categories_name[] = $category->name;
                }
                $customfieldType[$customfield->id] = implode(',', $categories_name) . " >> " . $customfield->name;
            } else {
                //All Category
                $customfieldType[$customfield->id] = trans('visiosoft.module.customfields::field.all') . " >> " .
                    $customfield->name;
            }
        }

        $fields = array_merge([
            'custom_field' => [
                'type' => 'anomaly.field_type.select',
                'config' => [
                    'options' => $customfieldType,
                ],
            ]
        ], $fields);

        $form->setFields($fields);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CfvalueFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CfvalueFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @param $id
     * @return array
     */
    public function getParentCategories($id)
    {
        $categories = array();
        $parents = $this->parent->getByCustomFieldID($id);

        foreach ($parents as $parent) {
            $category = $this->category->find($parent->cat_id);
            if ($category)
                $categories[] = $category;
        }
        return $categories;
    }
}
