<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Illuminate\Http\Request;
use Visiosoft\CustomfieldsModule\CustomField\Form\CustomFieldFormBuilder;
use Visiosoft\CustomfieldsModule\CustomField\Table\CustomFieldTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Addon\FieldType\FieldTypeCollection;

class CustomFieldsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CustomFieldTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomFieldTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CustomFieldFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CustomFieldFormBuilder $form, FieldTypeCollection $fieldTypes, Request $request)
    {

        $customfieldType = [];
        $fields = $form->getFields();
        foreach ($fieldTypes as $fieldType) {
            $customfieldType[$fieldType->slug] = $fieldType->slug;
        }

        $fields = array_merge([
            'type' => [
                'config' => [
                    'options' => $customfieldType
                ]
            ]
        ], $fields);
        $form->setFields($fields);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CustomFieldFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CustomFieldFormBuilder $form,FieldTypeCollection $fieldTypes, Request $request, $id)
    {
        return $form->render($id);
    }
}
