<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Http\Request;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\CustomfieldsModule\CustomField\Form\CustomFieldFormBuilder;
use Visiosoft\CustomfieldsModule\CustomField\Table\CustomFieldTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CustomfieldsModule\CustomField\Table\Filter\CategoryFilterQuery;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;

class CustomFieldsController extends AdminController
{
    /**
     * @var ParentModel
     */
    public $parent_model;

    /**
     * @var CategoryModel
     */
    public $category_model;

    /**
     * @var CustomFieldModel
     */
    public $model;

    /**
     * @var CustomFieldRepositoryInterface
     */
    public $customfield_repository;

    /**
     * @var CfvalueRepositoryInterface
     */
    public $CFValue_repository;
    /**
     * @var CustomFieldAdvRepositoryInterface
     */
    public $customfieldAdv_repository;
    /**
     * @var ParentRepositoryInterface
     */
    public $Parent_Repository;

    /**
     * CustomFieldsController constructor.
     * @param ParentModel $parent_model
     * @param CategoryModel $category_model
     * @param CustomFieldModel $model
     */
    public function __construct(
        ParentModel $parent_model,
        CategoryModel $category_model,
        CustomFieldModel $model,
        CustomFieldRepositoryInterface $customFieldRepository,
        CfvalueRepositoryInterface $cfvalueRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
        ParentRepositoryInterface $parentRepository
    )
    {
        $this->parent_model = $parent_model;
        $this->category_model = $category_model;
        $this->customfield_repository = $customFieldRepository;
        $this->customfieldAdv_repository = $customFieldAdvRepository;
        $this->CFValue_repository = $cfvalueRepository;
        $this->Parent_Repository = $parentRepository;
        $this->model = $model;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CustomFieldTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomFieldTableBuilder $table)
    {
        if ($this->request->action == "delete") {
            $id_list = $this->request->id;
            foreach ($id_list as $item) {
                $this->customfield_repository->deleteCF($item);
                $this->CFValue_repository->deleteByCF($item);
                $this->customfieldAdv_repository->deleteByCF($item);
                $this->Parent_Repository->deleteByCF($item);
            }

            $this->messages->success(trans('streams::message.delete_success', ['count' => count($id_list)]));
            return $this->redirect->to('/admin/customfields');
        }

        $table->setColumns([
            'parent_category' =>
                [
                    'value' => function (EntryInterface $entry) {
                        $parents = $this->parent_model->where('cf_id', $entry->id)->get()->pluck('cat_id');
                        $categoryName = array();
                        foreach ($parents as $parent) {
                            $category = $this->category_model->getCat($parent);
                            if ($category)
                                $categoryName[] = $category->name;
                        }
                        if (count($categoryName))
                            return implode(',', $categoryName);
                        else
                            return trans('visiosoft.module.customfields::field.all_categories.name');
                    }
                ],
            'name', 'type']);
        $table->setFilters([
            'cat_id' => [
                'exact' => true,
                'placeholder' => trans('visiosoft.module.customfields::field.all_categories.name'),
                'filter' => 'select',
                'query' => CategoryFilterQuery::class,
                'options' => function () {
                    $options = [];
                    foreach ($this->parent_model->get() as $item) {
                        if (!isset($options[$item->cat_id])) {
                            $category = $this->category_model->getCat($item->cat_id);
//                            dd($item->cat_id,$category);
                            if (!is_null($category))
                                $options[$category->id] = $category->name . " ";
                        }
                    }
                    return $options;

                }
            ], 'type' => [
                'exact' => true,
                'filter' => 'select',
                'options' => function () {
                    return [
                        "checkboxes" => "checkboxes",
                        "decimal" => "decimal",
                        "integer" => "integer",
                        "radio" => "radio",
                        "range" => "range",
                        "select" => "select",
                        "selectdropdown" => "select dropdown",
                        "selecttop" => "select top",
                        "selectrange" => "select range",
                        "selectimage" => "select image",
                        "text" => "text",
                    ];
                }
            ],
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CustomFieldFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CustomFieldFormBuilder $form, Request $request)
    {
        if ($request->action == "save") {
            $all = $request->all();
            if (!is_null($this->customfield_repository->findBySlug($request->slug))) {
                $this->messages->error(trans('streams::validation.unique', ['attribute' => "[Slug] <b>" . $request->slug . "</b>"]));
                return back();
            }

            if (empty($all['type'])) {
                $this->messages->error(trans('streams::validation.filled', ['attribute' => trans('visiosoft.module.customfields::field.type.name')]));
                return back();
            }

            $trans = preg_grep('/^name/i', array_keys($all));

            $langs = array();
            foreach ($trans as $key => $lang) {
                $langs[] = preg_replace('/^' . preg_quote('name_', '/') . '/', '', $lang);
            }

            $save_fields = array();
            foreach ($langs as $lang) {
                $save_fields[$lang] = [
                    'name' => trim($all['name_' . $lang]),
                    'description' => $all['description_' . $lang],
                ];
            }
            $save_fields['type'] = $all['type'];
            $save_fields['slug'] = $all['slug'];

            if (isset($request->seenList))
                $save_fields['seenList'] = 1;

            $cf_saved = $this->model->create($save_fields);

            $categories = $request->parent_category;
//            $this->parent_model->create([
//                'cf_id' => $cf_saved->id,
//                'cat_id' => $categories
//            ]);
            if ($categories != null) {
                foreach ($categories as $category) {
                    $this->parent_model->create([
                        'cf_id' => $cf_saved->id,
                        'cat_id' => $category
                    ]);
                }
            }

            $this->messages->success(trans('streams::message.create_success', ['name' => trans('visiosoft.module.customfields::addon.title')]));
            return redirect('/admin/customfields');
        }

        $customfieldType = [
            "checkboxes" => trans("visiosoft.module.customfields::field.checkboxes_type"),
            "decimal" => trans("visiosoft.module.customfields::field.decimal_type"),
            "integer" => trans("visiosoft.module.customfields::field.integer_type"),
            "radio" => trans("visiosoft.module.customfields::field.radio_type"),
            "range" => trans("visiosoft.module.customfields::field.range_type"),
            "select" => trans("visiosoft.module.customfields::field.select_type"),
            "selectdropdown" => trans("visiosoft.module.customfields::field.selectdropdown_type"),
            "selecttop" => trans("visiosoft.module.customfields::field.selecttop_type"),
            "selectrange" => trans("visiosoft.module.customfields::field.selectrange_type"),
            "selectimage" => trans("visiosoft.module.customfields::field.selectimage_type"),
            "text" => trans("visiosoft.module.customfields::field.text_type"),
        ];

        $fields = $form->getFields();

        $fields = array_merge([
            'type' => [
                'instructions' => function () {
                    $message = '<div class="alert alert-info alert-dismissible"><ul class="list-unstyled">';
                    foreach (trans('visiosoft.module.customfields::message.field_type.instructions') as $key => $item) {
                        $message .= "<li><b>" . ucfirst($key) . " Field:</b> " . $item . "</li>";
                    }
                    $message .= "</ul></div>";
                    return $message;
                },
                'config' => [
                    'mode' => 'search',
                    'options' => $customfieldType
                ]
            ],
        ], $fields);
        $form->setFields($fields);
        $form->setActions(['save']);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CustomFieldFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CustomFieldFormBuilder $form, Request $request, $id)
    {
        if ($request->action == "update") {

            $this->parent_model->where('cf_id', $id)->delete();
            $categories = $request->parent_category;

            if ($categories) {
                foreach ($categories as $category) {
                    $this->parent_model->create([
                        'cf_id' => $id,
                        'cat_id' => $category
                    ]);
                }
            }

            $all = $request->all();
            $trans = preg_grep('/^name/i', array_keys($all));

            $langs = array();
            foreach ($trans as $key => $lang) {
                $langs[] = preg_replace('/^' . preg_quote('name_', '/') . '/', '', $lang);
            }

            $save_fields = array();
            foreach ($langs as $lang) {
                $save_fields[$lang] = [
                    'name' => $all['name_' . $lang],
                    'description' => $all['description_' . $lang],
                ];
            }

            if (isset($request->seenList))
                $save_fields['seenList'] = 1;

            $this->model->find($id)->update($save_fields);

            $this->messages->success(trans('streams::message.edit_success', ['name' => trans('visiosoft.module.customfields::addon.title')]));
            return redirect('/admin/customfields');
        }

        $form->setActions(['update']);
        $form->setFields([
            'name', 'description', 'seenList'
        ]);

        $form->setOptions(['redirect' => '/admin/customfields']);

        return $form->render($id);
    }
}
