<?php namespace Visiosoft\CustomfieldsModule\CustomFieldAdv;

use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CustomFieldAdvRepository extends EntryRepository implements CustomFieldAdvRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CustomFieldAdvModel
     */
    protected $model;

    /**
     * Create a new CustomFieldAdvRepository instance.
     *
     * @param CustomFieldAdvModel $model
     */
    public function __construct(CustomFieldAdvModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $id
     * @return mixed
     */
    public function deleteByCf($id)
    {
        return $this->model->where('custom_field_category_id', $id)->delete();
    }


    public function deleteByCFValue($id, $delete_id)
    {
        $CFAdv = $this->model->where('custom_field_category_id', $id)->first();
        if (!is_null($CFAdv)) {
            if ($CFAdv->custom_field_type == "checkboxes") {
                $CFValues = explode(',', $CFAdv->custom_field_value);
                unset($CFValues[array_search($delete_id, $CFValues)]);
                if (count($CFValues) > 0) {
                    return $CFAdv->update(['custom_field_value' => implode(',', $CFValues)]);
                } else {
                    return $CFAdv->delete();
                }
            } else {
                return $CFAdv->delete();
            }
        }
    }
}
