<?php namespace Visiosoft\CustomfieldsModule\CustomField\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class CustomFieldFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'slug',
        // 'custom_field_select_options',
        'description',
        'seenList'
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'form_view' => 'visiosoft.module.customfields::form'
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
    ];

}
