<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Anomaly\MultipleFieldType\MultipleFieldType;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\CustomfieldsModule\CustomField\Form\CustomFieldFormBuilder;
use Visiosoft\CustomfieldsModule\CustomField\Handler\CustomfieldsParentSearchOptions;
use Visiosoft\CustomfieldsModule\CustomField\Table\CustomFieldTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Addon\FieldType\FieldTypeCollection;

class CustomFieldsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CustomFieldTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomFieldTableBuilder $table)
    {
        $table->setFilters([
            'parent_category' => [
                'filter' => 'select',
                'options' => function (CustomFieldModel $model, CategoryModel $categoryModel) {
                    $options = [];
                    foreach ($model->get() as $item) {
                        if (!isset($options[$item->parent_category]))
                            $options[$item->parent_category] = $categoryModel->getMeta_title($item->parent_category);
                    }
                    return $options;

                }
            ],
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CustomFieldFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CustomFieldFormBuilder $form, FieldTypeCollection $fieldTypes, Request $request, CustomFieldModel $customFieldModel)
    {
        if ($request->action == "save") {
            $all = $request->all();
            $trans = preg_grep('/^name/i', array_keys($all));

            $langs = array();
            foreach ($trans as $key => $lang) {
                $langs[] = preg_replace('/^' . preg_quote('name_', '/') . '/', '', $lang);
            }

            $saved_trans_fields = array();
            foreach ($langs as $lang)
            {
                $saved_trans_fields[$lang] = [
                    'name' => $all['name_'.$lang],
                    'description' => $all['description_'.$lang],
                ];
            }

            $categories = $request->parent_category;
            foreach ($categories as $category) {
                $customFieldModel->create(array_merge($saved_trans_fields,[
                    'parent_category' => $category,
                    'slug' => $all['slug'].$category,
                    'type' => $all['type']
                ]));
            }
            $this->messages->success(trans('streams::message.create_success', ['name' => trans('visiosoft.module.customfields::addon.title')]));
            return redirect('/admin/customfields');
            die;

        }

        $customfieldType = [];
        $fields = $form->getFields();

        // foreach ($fieldTypes as $fieldType) {
        //     $customfieldType[$fieldType->slug] = $fieldType->slug;
        // }

        $customfieldType = [
            "checkboxes" => "checkboxes",
            "decimal" => "decimal",
            "integer" => "integer",
            "json" => "json",
            "radio" => "radio",
            "range" => "range",
            "select" => "select",
            "selecttop" => "selecttop",
            "tags" => "tags",
            "text" => "text",
            "textarea" => "textarea",
            "url" => "url",
            "wysiwyg" => "wysiwyg"
        ];

        $fields = array_merge([
            'type' => [
                'config' => [
                    'options' => $customfieldType
                ]
            ],
        ], $fields);
        $form->setFields($fields);
        $form->setActions(['save']);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CustomFieldFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CustomFieldFormBuilder $form, FieldTypeCollection $fieldTypes, Request $request, $id)
    {
        $form->setFields([
            'name'
        ]);
        return $form->render($id);
    }
}
