$(document).ready(function () {
    var selected;
    $("select[name='parent_category[]']").select2({
        ajax: {
            url: window.location.origin + "/keySearch",
            type: "GET",
            data: function (params) {
                if($(this).val() != null)
                    selected = $(this).val().join("-")
                return {
                    q: params.term, // search term
                    selected: selected
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data.category, function (item) {
                        return {
                            text: item.parents,
                            id: item.id
                        }
                    })
                };
            },
            cache: true
        },
        allowClear: true,
        theme: "classic",
        placeholder: "All",
        minimumInputLength: 3
    });
});
