<?php namespace Visiosoft\CustomfieldsModule\CustomField;

use Anomaly\Streams\Platform\Model\EloquentModel;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CustomFieldRepository extends EntryRepository implements CustomFieldRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CustomFieldModel
     */
    protected $model;

    /**
     * Create a new CustomFieldRepository instance.
     *
     * @param CustomFieldModel $model
     */
    public function __construct(CustomFieldModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $slug
     * @return mixed
     */
    public function findBySlug($slug)
    {
        return $this->model->where('slug', $slug)->first();
    }

    /**
     * @param $id
     * @return mixed
     */
    public function deleteCF($id)
    {
        return $this->model->find($id)->delete();
    }
}
