<?php namespace Visiosoft\CustomfieldsModule\Cfvalue\Form;

use Visiosoft\CustomfieldsModule\Cfvalue\CfvalueModel;

class CfvalueFormHandler
{
	public function handle(
		CfvalueFormBuilder $builder
	)
	{
		if ($builder->getForm()->getMode() !== 'create') {
			$builder->saveForm();
			return;
		}

		$values = $builder->getFormValues()->toArray();
		$newCFCount = count(max($values));
		$newArray = array();
		for ($i = 0; $i < $newCFCount; $i++) {
			foreach ($values as $index => $langValue) {
				$newArray[$i][$index] =
					isset($langValue[$i]) ? $langValue[$i] : '';
			}
		}

        foreach ($newArray as $items) {
            $builder->setFormEntry(new CfvalueModel());

            foreach ($items as $key => $item) {
                $item = ($item == "zero") ? "0" : $item;
                $builder->setFormValue($key, $item);
            }

            $builder->saveForm();
            $entry = $builder->getFormEntry();
            $type = request()->type;
            if ($type) {
                $entry->custom_field_id = $type;
            }
            $entry->save();
        }
    }

}
