<?php namespace Visiosoft\CustomfieldsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCustomFieldAdvsEntryModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Anomaly\Streams\Platform\Addon\FieldType\FieldType;

class CustomFieldsController extends PublicController
{
    private $model;
    private $category_model;
    private $adv_repository;
    private $cfvalueRepository;
    private $customFieldRepository;

    public function __construct(
        CustomfieldModel $customFieldModel,
        CategoryModel $categoryModel,
        AdvRepositoryInterface $advRepository,
        CfvalueRepositoryInterface $cfvalueRepository,
        CustomFieldRepositoryInterface $customFieldRepository
    )
    {
        $this->model = $customFieldModel;
        $this->category_model = $categoryModel;
        $this->adv_repository = $advRepository;
        $this->cfvalueRepository = $cfvalueRepository;
        parent::__construct();
        $this->customFieldRepository = $customFieldRepository;
    }

    public function isCFAdded($array, $search)
    {
        if (count($array) < 1)
            return false;

        foreach ($array as $item) {
            $status = in_array($search, $item);
            if ($status) {
                return $status;
                break;
            }
        }
    }

    public function index($mainCats, $subCats, $categoryId)
    {
        $checkboxes = array();
        $topfields = array();
        $selectRange = array();
        $selectImage = array();
        $selectDropdown = array();
        $ranges = array();
        $radio = array();
        $text = array();

        $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID();
        foreach ($findcustomfields as $findcustomfield) {
            if ($findcustomfield->type != 'checkboxes' and $findcustomfield->cat_id == null) {
                $cfcheckbox = array();
                $cfcheckbox['id'] = $findcustomfield->id;
                $cfcheckbox['name'] = $findcustomfield->name;
                $cfcheckbox['show_filter'] = $findcustomfield->show_filter;
                if ($findcustomfield->type == 'range') {
                    $ranges[] = $cfcheckbox;
                } else {
                    if ($findcustomfield->cfvalues()->count() > 0) {
                        foreach ($findcustomfield->cfvalues as $v) {
                            $cfcheckbox['values'][$v->id] = $findcustomfield->type == "selectimage" ?
                                ['value' => $v->custom_field_value, 'image' => $v->custom_field_image_id] :
                                $v->custom_field_value;
                        }
                        if ($findcustomfield->type == "selecttop") {
                            $topfields[] = $cfcheckbox;
                        } else if ($findcustomfield->type == "selectdropdown") {
                            $selectDropdown[] = $cfcheckbox;
                        } else if ($findcustomfield->type == "selectrange") {
                            $selectRange[] = $cfcheckbox;
                        } else if ($findcustomfield->type == "selectimage") {
                            $selectImage[] = $cfcheckbox;
                        } else if ($findcustomfield->type == "radio") {
                            $cfcheckbox['values'][""] = trans('visiosoft.module.customfields::field.all');
                            asort($cfcheckbox['values']);
                            $radio[] = $cfcheckbox;
                        } else {
                            if (!$this->isCFAdded($checkboxes, $cfcheckbox['id']))
                                $checkboxes[] = $cfcheckbox;
                        }
                    } else {
                        if ($findcustomfield->type == "text") {
                            $text[] = $cfcheckbox;
                        }
                    }
                }
            }
        }

        if (!is_null($categoryId)) {
            foreach ($mainCats as $mainCat) {
                $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID($mainCat['id']);
                foreach ($findcustomfields as $findcustomfield) {
                    if ($findcustomfield->type != 'checkboxes') {
                        $cfcheckbox = array();
                        $cfcheckbox['id'] = $findcustomfield->id;
                        $cfcheckbox['name'] = $findcustomfield->name;
                        if ($findcustomfield->type == 'range') {
                            $ranges[] = $cfcheckbox;
                        } else {
                            if ($findcustomfield->cfvalues()->count() > 0) {
                                foreach ($findcustomfield->cfvalues as $v) {
                                    $cfcheckbox['values'][$v->id] = $findcustomfield->type == "selectimage" ?
                                        ['value' => $v->custom_field_value, 'image' => $v->custom_field_image_id] :
                                        $v->custom_field_value;
                                }
                                if ($findcustomfield->type == "selecttop") {
                                    $topfields[] = $cfcheckbox;
                                } else if ($findcustomfield->type == "selectdropdown") {
                                    $selectDropdown[] = $cfcheckbox;
                                } else if ($findcustomfield->type == "selectrange") {
                                    $selectRange[] = $cfcheckbox;
                                } else if ($findcustomfield->type == "selectimage") {
                                    $selectImage[] = $cfcheckbox;
                                } else if ($findcustomfield->type == "radio") {
                                    $cfcheckbox['values'][""] = trans('visiosoft.module.customfields::field.all');
                                    asort($cfcheckbox['values']);
                                    $radio[] = $cfcheckbox;
                                } else {
                                    if (!$this->isCFAdded($checkboxes, $cfcheckbox['id']))
                                        $checkboxes[] = $cfcheckbox;
                                }
                            } else {
                                if ($findcustomfield->type == "text") {
                                    $text[] = $cfcheckbox;
                                }
                            }
                        }
                    }
                }
            }
        }

        return $returns = array('checkboxes' => $checkboxes, 'topfields' => $topfields, 'ranges' => $ranges,
            'radio' => $radio, 'selectRange' => $selectRange, 'selectImage' => $selectImage,
            'selectDropdown' => $selectDropdown, 'text' => $text);
    }

    public function view($adv)
    {
        $cf_array = json_decode($adv['cf_json'], true);
        $features = array();
        $not_null_id = array();
        $findcustomfields = $adv->customfields;
        foreach ($findcustomfields as $fcf) {
            if ($fcf->customfield) {
                $not_null_id[] = $fcf->customfield->id;
                if ($fcf->customfield->cfvalues()->count() > 0 && isset($cf_array['cf' . $fcf->customfield->id]) && is_array($cf_array['cf' . $fcf->customfield->id])) {
                    $customfieldsmulti = array();
                    foreach ($fcf->customfield->cfvalues as $allcfval) {

                        if (in_array($allcfval->id, $cf_array['cf' . $fcf->customfield->id])) {
                            $customfieldsmulti[$allcfval->id] = ['val' => $allcfval->custom_field_value, 'status' => 1];
                        } else {
                            $customfieldsmulti[$allcfval->id] = ['val' => $allcfval->custom_field_value, 'status' => 0];
                        }
                    }


                    // foreach ($cf_array['cf' . $fcf->customfield->id] as $vv) {


                    //     $customfieldsmulti[] = $fcf->customfield->cfvalues()->find($vv)->custom_field_value;


                    //     // if($vv == $cf_array['cf'.$fcf->customfield->id]){
                    //     // $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $fcf->customfield->cfvalues()->find($vv)->custom_field_value];
                    //     // }
                    // }
                    if (!$this->isCFAdded($features, $fcf->customfield->name)) {
                        $features[] = ['name' => $fcf->customfield->name, 'custom_field_value' => $customfieldsmulti];
                    }
                } else if ($fcf->customfield->cfvalues()->count() > 0) {
                    if (!$this->isCFAdded($features, $fcf->customfield->name)) {
                        if ($fcf->customfield->type === 'selectrange') {
                            $features[] = [
                                'name' => $fcf->customfield->name,
                                'custom_field_value' => $fcf->custom_field_value
                            ];
                        } elseif ($this->cfvalueRepository->find($fcf->custom_field_value)) {
                            $features[] = [
                                'name' => $fcf->customfield->name,
                                'slug' => $fcf->customfield->slug,
                                'custom_field_value' => $this->cfvalueRepository->find($fcf->custom_field_value)->custom_field_value
                            ];
                        }
                    }
                } else {
                    if (!$this->isCFAdded($features, $fcf->customfield->name)) {
                        $features[] = [
                            'name' => $fcf->customfield->name,
                            'slug' => $fcf->customfield->slug,
                            'custom_field_value' => $fcf->custom_field_value
                        ];
                    }
                }
            }
        }

        $customfields_unselect_checkboxed = array();
        foreach ($adv->toArray() as $key => $field) {
            if (preg_match('/cat\d/', $key) and !is_null($field)) {
                $customfields_unselect_checkboxed[] = $this->customFieldRepository
                    ->customfieldsJoinCategoryWithCategoryID($field)
                    ->whereNotIn('customfields_custom_fields.id', $not_null_id)
                    ->get();
            }
        }

        foreach ($customfields_unselect_checkboxed as $cutomfieldsCategory) {
            foreach ($cutomfieldsCategory as $customfields) {
                if ($customfields->cfvalues()->count() > 0) {
                    $customfieldsmulti = array();
                    if ($customfields->type == "checkboxes") {
                        foreach ($customfields->cfvalues as $allcfval) {
                            $customfieldsmulti[$allcfval->id] = ['val' => $allcfval->custom_field_value, 'status' => 0];
                        }
                    } else {
                        $customfieldsmulti = "-";
                    }

                    if (!$this->isCFAdded($features, $customfields->name)) {
                        $features[] = ['name' => $customfields->name, 'custom_field_value' => $customfieldsmulti];
                    }
                }
            }
        }

        $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID();
        foreach ($findcustomfields as $customfields) {
            if ($customfields->cfvalues()->count() > 0 and $customfields->cat_id == null) {
                $customfieldsmulti = array();
                if ($customfields->type == "checkboxes") {
                    foreach ($customfields->cfvalues as $allcfval) {
                        $customfieldsmulti[$allcfval->id] = ['val' => $allcfval->custom_field_value, 'status' => 0];
                    }
                } else {
                    $customfieldsmulti = "-";
                }

                if (!$this->isCFAdded($features, $customfields->name)) {
                    $features[] = ['name' => $customfields->name, 'custom_field_value' => $customfieldsmulti];
                }
            }
        }

        return $features;
    }

    public function create($categories)
    {
        foreach ($categories as $category) {
            if ($cats[$category] != 0) {
                $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID($cats[$category]);

                foreach ($findcustomfields as $findcustomfield) {
                    $field_type = new FieldType;
                    // $field_type->setField('cf__'.$findcustomfield->translations->first()->name);
                    $field_type->setField('cf__' . $findcustomfield->slug);
                    if ($findcustomfield->cfvalues()->count() > 0) {
                        $values = array();
                        foreach ($findcustomfield->cfvalues as $v) {
                            $values[$v->id] = $v->custom_field_value;
                        }
                        $field_type->options = $values;
                        if ($findcustomfield->type == 'select' || $findcustomfield->type == 'selecttop') {
                            if (view()->exists('anomaly.field_type.select::dropdown')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.select::dropdown')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        } else if ($findcustomfield->type == 'checkboxes') {
                            if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        } else if ($findcustomfield->type == 'radio') {
                            if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::radio')) {
                                $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::radio')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                            }
                        }
                    } else {
                        if ($findcustomfield->type == 'range') {
                            $findtype = "integer";
                        } else {
                            $findtype = $findcustomfield->type;
                        }
                        $view = 'anomaly.field_type.' . $findtype . '::input';
                        if (view()->exists($view)) {
                            $custom_fields[] = ['custom_field_input' => view($view)->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name];
                        }
                    }
                }
            }
        }
        return $custom_fields;
    }

    public function edit($adv, $categories, $cats)
    {
        $custom_fields = array();
        $cf_array = json_decode($adv['cf_json'], true);
        if (!is_array($cf_array)) {
            $cf_array = array();
        }

        $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID();

        foreach ($findcustomfields as $findcustomfield) {
            if ($findcustomfield->cat_id == null) {
                $field_type = new FieldType;
                // $field_type->setField('cf__'.$findcustomfield->translations->first()->name);
                $field_type->setField('cf__' . $findcustomfield->slug);
                $field_type->addAttribute('required', $findcustomfield->required);
                if (array_key_exists('cf' . $findcustomfield->id, $cf_array)) {
                    $field_type->setValue($cf_array['cf' . $findcustomfield->id]);
                    $field_type->key = $cf_array['cf' . $findcustomfield->id];
                }
                if ($findcustomfield->cfvalues()->count() > 0) {
                    $values = array();
                    foreach ($findcustomfield->cfvalues as $v) {
                        $key = $findcustomfield->type == 'selectrange' ? $v->custom_field_value : $v->id;
                        $values[$key] = $v->custom_field_value;
                    }
                    $field_type->options = $values;
                    if ($findcustomfield->type == 'select'
                        || $findcustomfield->type == 'selecttop'
                        || $findcustomfield->type == 'selectdropdown'
                        || $findcustomfield->type == 'selectrange'
                        || $findcustomfield->type == 'selectimage') {
                        if (view()->exists('anomaly.field_type.select::dropdown')) {
                            if (!$this->isCFAdded($custom_fields, $findcustomfield->name)) {
                                $field_type->setPlaceholder('visiosoft.module.customfields::field.select.name');
                                $custom_fields[] = ['type' => $findcustomfield->type, 'custom_field_input' => view('anomaly.field_type.select::dropdown')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                            }
                        }
                    } else if ($findcustomfield->type == 'checkboxes') {
                        if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')) {
                            if (!$this->isCFAdded($custom_fields, $findcustomfield->name))
                                $custom_fields[] = ['type' => $findcustomfield->type, 'custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                        }
                    } else if ($findcustomfield->type == 'radio') {
                        if (view()->exists('visiosoft.field_type.' . $findcustomfield->type . '::radio')) {
                            if (!$this->isCFAdded($custom_fields, $findcustomfield->name))
                                $custom_fields[] = ['type' => $findcustomfield->type, 'custom_field_input' => view('visiosoft.field_type.' . $findcustomfield->type . '::radio')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                        }
                    }
                } else {
                    if ($findcustomfield->type == 'range') {
                        $findtype = "integer";
                    } else {
                        $findtype = $findcustomfield->type;
                    }
                    $view = 'anomaly.field_type.' . $findtype . '::input';
                    if (view()->exists($view)) {
                        if ($findcustomfield->config) {
                            $cf_field_config = json_decode($findcustomfield->config, true);
                            if (isset($cf_field_config['config_min'])) {
                                $field_type->configSet('min', $cf_field_config['config_min']);
                            }
                            if (isset($cf_field_config['config_max'])) {
                                $field_type->configSet('max', $cf_field_config['config_max']);
                            }
                        }
                        if (!$this->isCFAdded($custom_fields, $findcustomfield->name))
                            $custom_fields[] = ['type' => $findcustomfield->type, 'custom_field_input' => view($view)->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                    }
                }
            }
        }


        foreach ($categories as $category) {

            if ($cats[$category] != 0) {
                $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID($cats[$category]);
                foreach ($findcustomfields as $findcustomfield) {
                    $field_type = new FieldType;
                    // $field_type->setField('cf__'.$findcustomfield->translations->first()->name);
                    $field_type->setField('cf__' . $findcustomfield->slug);
                    $field_type->addAttribute('required', $findcustomfield->required);
                    if (array_key_exists('cf' . $findcustomfield->id, $cf_array)) {
                        $field_type->setValue($cf_array['cf' . $findcustomfield->id]);
                        $field_type->key = $cf_array['cf' . $findcustomfield->id];
                    }
                    if ($findcustomfield->cfvalues()->count() > 0) {
                        $values = array();
                        foreach ($findcustomfield->cfvalues as $v) {
                            $key = $findcustomfield->type == 'selectrange' ? $v->custom_field_value : $v->id;
                            $values[$key] = $v->custom_field_value;
                        }
                        $field_type->options = $values;
                        if ($findcustomfield->type == 'select'
                            || $findcustomfield->type == 'selecttop'
                            || $findcustomfield->type == 'selectdropdown'
                            || $findcustomfield->type == 'selectrange'
                            || $findcustomfield->type == 'selectimage') {
                            if (view()->exists('anomaly.field_type.select::dropdown')) {
                                if (!$this->isCFAdded($custom_fields, $findcustomfield->name)) {
                                    $field_type->setPlaceholder('visiosoft.module.customfields::field.select.name');
                                    $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.select::dropdown')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                                }
                            }
                        } else if ($findcustomfield->type == 'checkboxes') {
                            if (view()->exists('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')) {
                                if (!$this->isCFAdded($custom_fields, $findcustomfield->name))
                                    $custom_fields[] = ['custom_field_input' => view('anomaly.field_type.' . $findcustomfield->type . '::checkboxes')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                            }
                        } else if ($findcustomfield->type == 'radio') {
                            if (view()->exists('visiosoft.field_type.radio::radio')) {
                                if (!$this->isCFAdded($custom_fields, $findcustomfield->name))
                                    $custom_fields[] = ['custom_field_input' => view('visiosoft.field_type.radio::radio')->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                            }
                        }
                    } else {
                        if ($findcustomfield->type == 'range') {
                            $findtype = "integer";
                        } else {
                            $findtype = $findcustomfield->type;
                        }
                        $view = 'anomaly.field_type.' . $findtype . '::input';
                        if (view()->exists($view)) {
                            if (!$this->isCFAdded($custom_fields, $findcustomfield->name))
                                $custom_fields[] = ['custom_field_input' => view($view)->with('field_type', $field_type)->render(), 'custom_field_label' => $findcustomfield->name,'custom_field_slug' => $findcustomfield->slug];
                        }
                    }
                }
            }
        }
        return $custom_fields;
    }

    public function filterSearch($customParameters, $param, $query)
    {
        foreach ($param as $para => $value) {
            if (substr($para, 4, 3) === "cf_") {
                $id = substr($para, 7);
                $minmax = substr($para, 0, 3);
                if ($minmax == 'min') {
                    $num = $param[$minmax . '_cf_' . $id];
                    if ($num != "") {
                        $int = (int)$num;
                        $column = "JSON_EXTRACT(cf_json, '$.cf" . $id . "') >= " . $int;
                        $query = $query->whereRaw($column);
                    }
                }
                if ($minmax == 'max') {
                    $num = $param[$minmax . '_cf_' . $id];
                    if ($num != "") {
                        $int = (int)$num;
                        $column = "JSON_EXTRACT(cf_json, '$.cf" . $id . "') <= " . $int;
                        $query = $query->whereRaw($column);
                    }
                }
            }
        }

        foreach ($customParameters as $key => $customParameter) {
            if ($customParameter['value'] == "" or $customParameter['value'][0] == "") {
                unset($customParameters[$key]);
            }
        }
        $customParameters = array_values($customParameters);

        foreach ($customParameters as $key => $customParameter) {
            if ($key == 0) {
                $jsonQuery = "(";
            }
            $cfId = $customParameter['id'];
            $cfValue = $customParameter['value'];
            $cf = "'" . $cfId . "'";
            $cfType = $this->customFieldRepository->find(substr($cfId, strpos($cfId, "cf") + 2));
            if ($cfType && $cfType->checkType('selectimage')) {
                $cfValue = explode(',', $cfValue);
            }
            if (!is_array($cfValue)) {
                $cfValue = [$cfValue];
            }
            $valueCount = count($cfValue);
            if ($cfValue) {
                foreach ($cfValue as $key1 => $value) {
                    if ($key1 == 0 and $cfValue > 1) {
                        $jsonQuery = $jsonQuery . "(";
                    }
                    $jsonQuery = $jsonQuery . 'JSON_CONTAINS(cf_json, \'"' . $value . '"\', ' . $cf . ')';
                    if ($key1 == $valueCount - 1 and $cfValue > 1) {
                        $jsonQuery = $jsonQuery . ")";
                    }
                    if ($key1 < $valueCount - 1) {
                        $jsonQuery = $jsonQuery . " or ";
                    } elseif ($key1 == $valueCount - 1 and $key != count($customParameters) - 1) {
                        $jsonQuery = $jsonQuery . " and ";
                    }
                }
            }
            if ($key == count($customParameters) - 1) {
                $jsonQuery = $jsonQuery . ")";
            }
        }

        if (isset($jsonQuery)) {
            return $query->whereRaw($jsonQuery);
        } else
            return $query;
    }

    public function store($adv, $request)
    {
        $jsonVal = [];
        $adv_id = $adv->id;

        //Delete Old
        CustomfieldsCustomFieldAdvsEntryModel::query()->where('parent_adv_id', $request->update_id)
            ->forceDelete();
        for ($i = 1; $i < 7; $i++) {
            $cat = 'cat' . $i;
            if ($request->$cat != 0) {
                $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID($request->$cat);
                foreach ($findcustomfields as $findcustomfield) {
                    $cs_name = 'cf__' . $findcustomfield->slug;
                    $cf_id = "cf" . $findcustomfield->id;
                    if ($request->$cs_name) {
                        $new_cs = new CustomfieldsCustomFieldAdvsEntryModel();
                        $new_cs->parent_adv_id = $adv_id;
                        $new_cs->custom_field_category_id = $findcustomfield->id;
                        $new_cs->custom_field_type = $findcustomfield->type;
                        if (is_array($request->$cs_name)) {
                            $new_cs->custom_field_value = implode(',', $request->$cs_name);
                        } else {
                            $new_cs->custom_field_value = $request->$cs_name;
                        }
                        $jsonVal[$cf_id] = $request->$cs_name;
                        $new_cs->save();
                    }
                }
            }
        }

        $findcustomfields = $this->customFieldRepository->getCustomfieldsJoinCategoryWithCategoryID();
        foreach ($findcustomfields as $findcustomfield) {
            $cs_name = 'cf__' . $findcustomfield->slug;
            $cf_id = "cf" . $findcustomfield->id;
            if ($request->$cs_name) {
                $new_cs = new CustomfieldsCustomFieldAdvsEntryModel();
                $new_cs->parent_adv_id = $adv_id;
                $new_cs->custom_field_category_id = $findcustomfield->id;
                $new_cs->custom_field_type = $findcustomfield->type;
                if (is_array($request->$cs_name)) {
                    $new_cs->custom_field_value = implode(',', $request->$cs_name);
                } else {
                    $new_cs->custom_field_value = $request->$cs_name;
                }
                $jsonVal[$cf_id] = $request->$cs_name;
                $new_cs->save();
            }
        }


        $adv->cf_json = json_encode($jsonVal);
        $adv->save();
    }

    public function whereJsonContains($query, $column, $value)
    {
        return $query->whereRaw('JSON_CONTAINS(cf_json, \'"' . $value . '"\', \'$.cf' . $column . '\')')->get();
    }

    public function getCfValue(CfvalueRepositoryInterface $cfvalueRepository, $cf)
    {
        $cfValue = $cfvalueRepository->newQuery()->where('custom_field_id', $cf)->get();
        return $this->response->json($cfValue);
    }
}
