<?php

namespace Visiosoft\CropModule\Console\Commands;


use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Console\Command;
use Visiosoft\CropModule\Cropper\Form\BuildJSON;

class Run extends Command
{

    protected $signature = 'run:crop';

    protected $description = "run:crop Start Cropping";

    public function handle()
    {
        $data = new Collection();

        $data->put(
            'percent',
            $this->ask(
                'Enter percent (integer)',
                8
            )
        );

        $data->put(
            'catid',
            $this->ask(
                'Enter catid (integer)',
                47
            )
        );

        $data->put(
            'min_label',
            $this->ask(
                'Enter min_label (integer)',
                1
            )
        );

        $data->put(
            'max_limit',
            $this->ask(
                'Enter max_limit (integer)',
                5
            )
        );

        $data->put('download', ($this->confirm('Download?')) ? true : false);


        $data->put(
            'resolution',
            $this->ask(
                'Enter resolution (Ex: 1024x2048)',
                null
            )
        );

        $data->put(
            'pixel',
            $this->ask(
                'Enter pixel (Ex: 512 | integer)',
                null
            )
        );

        $this->info('Started cropping...');

        $options = [
            'types' => array($data->catid),
            'min_label_of_category' => $data->min_label,
            'debug' => false,
            'max_limit' => $data->max_limit,
            'download_image' => $data->download,
            'image_resolution' => $data->resolution,
            'crop_image' => ($data->pixel) ? true : false,
            'create_xml' => ($data->pixel) ? true : false
        ];

        $filename = dispatch_now(new BuildJSON("",
            $data->percent,
            ($data->pixel) ? $data->pixel : 0,
            $options
        ));
        $this->info($filename);
        $this->info("Process finished");
    }
}
