<?php namespace Visiosoft\CropModule\Cropper\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

use Visio\DirectoryManagementModule\Type\TypeModel;


class CropperFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'path' => [
            'label' => 'path',
            'required' => true,
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "C:\\tensorflow1\\models\\research\\object_detection\\images\\"
            ],
        ],
        'percent_of_training_data' => [
            'required' => true,
            'label' => 'percent_of_training_data',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 8
            ],
        ],
        'genislet' => [
            'label' => 'genislet',
            'required' => true,
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 512
            ],
        ],
        'categories' => [
            'label' => 'categories',
            'type' => 'anomaly.field_type.multiple',
            'required' => false,
            'config' => [
                "min" => 1,
                'related' => TypeModel::class,
            ]
        ],
        'min_label_of_category' => [
            'label' => 'min_label_of_category',
            'required' => true,
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 1
            ],
        ],
        'max_limit' => [
            'label' => 'max_limit',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => null
            ],
        ],
        'debug' => [
            'label' => 'debug',
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => 'admin/crop'
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];


}
