<?php
namespace Visiosoft\CropModule\Console\Commands;


use Illuminate\Console\Command;
use Visiosoft\CropModule\Cropper\Form\BuildJSON;

class Run extends Command
{

	protected $signature = 'run {percent} {pixel} {catid} {min_label} {max_limit}';

	protected $description = "run like: {percent} {pixel} {catid} {min_label} {max_limit} :> 8 512 47 1 50";

	public function __construct()
	{
		parent::__construct();
	}

	public function handle()
	{
        $this->info('Started cropping...');

        $options = [
            'types' => array($this->argument('catid')),
            'min_label_of_category' => $this->argument('min_label'),
            'debug' => false,
            'max_limit' => $this->argument('max_limit'),
        ];

        $filename = dispatch_now(new BuildJSON("",
                                            $this->argument('percent'),
                                            $this->argument('pixel'),
                                            $options
                                        ));
        $this->info($filename);
        $this->info("Process finished");
    }
}
