<?php namespace Visiosoft\CropModule\Cropper\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

use Visio\DirectoryManagementModule\Type\TypeModel;


class CropperFormBuilder extends FormBuilder
{
    protected $sections = [
        'monitoring' => [
            'stacked' => false,
            'tabs' => [
                'ads_detail' => [
                    'title' => 'visiosoft.module.crop::section.general.title',
                    'fields' => [
                        'percent_of_training_data',
                        'image_resolution',
                        'categories',
//                        'min_label_of_category',
                        'max_limit',
                        'download_image'
                    ]
                ],
                'crop' => [
                    'title' => 'visiosoft.module.crop::section.crop.title',
                    'fields' => [
                        'crop_image',
                        'crop_size',
                    ]
                ],
                'xml' => [
                    'title' => 'visiosoft.module.crop::section.xml.title',
                    'fields' => [
                        'create_xml',
                        'path',
                    ]
                ],
                'debug' => [
                    'title' => 'visiosoft.module.crop::section.debug.title',
                    'fields' => [
                        'debug',
                    ]
                ],
            ],
        ],
    ];

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'path' => [
            'label' => 'path',
            'required' => true,
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "C:\\tensorflow1\\models\\research\\object_detection\\images\\"
            ],
        ],
        'percent_of_training_data' => [
            'required' => true,
            'label' => 'percent_of_training_data ( % )',
            'type' => 'anomaly.field_type.select',
            'config' => [
                'default_value' => '80',
                'options' => [
                    '20' => '20',
                    '40' => '40',
                    '60' => '60',
                    '80' => '80',
                    '100' => '100',
                ],
                'mode' => 'buttons',
                'button_type' => 'warning'
            ],
        ],
        'crop_size' => [
            'label' => 'crop_size',
            'required' => true,
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 512
            ],
        ],
        'image_resolution' => [
            'label' => 'image_resolution',
            'required' => true,
            'type' => 'anomaly.field_type.select',
            'config' => [
                'default_value' => '1024x2048',
                'options' => [
                    '1024x2048' => '1024x2048',
                    '512x1024' => '512x1024',
                    '1024x1024' => '1024x1024'
                ],
                'mode' => 'buttons'
            ],
        ],
        'categories' => [
            'label' => 'categories',
            'type' => 'anomaly.field_type.multiple',
            'required' => false,
            'config' => [
                "min" => 1,
                'related' => TypeModel::class,
            ]
        ],
//        'min_label_of_category' => [
//            'label' => 'min_label_of_category',
//            'required' => true,
//            'type' => 'anomaly.field_type.integer',
//            'config' => [
//                'default_value' => 1
//            ],
//        ],
        'max_limit' => [
            'label' => 'max_limit',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => null
            ],
        ],
        'debug' => [
            'label' => 'debug',
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'crop_image' => [
            'label' => 'crop_image',
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'download_image' => [
            'label' => 'download_image',
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'create_xml' => [
            'label' => 'create_xml',
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => 'admin/crop'
    ];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];


}
