<?php

namespace Visiosoft\CropModule\Cropper\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Filesystem\Filesystem;

class BuildJSON2
{
    protected $path;
    protected $percent_of_training_data;
    protected $isTest;
    protected $expand;
    protected $options;

    public function __construct($path, $percent_of_training_data = 8, $expand = 512, $options = [])
    {
        $this->path = $path;
        $this->percent_of_training_data = $percent_of_training_data;
        $this->expand = $expand;
        $this->options = $options;
        $this->isTest = $this->percent_of_training_data == 10 ? false : true;
    }

    public function handle(MessageBag $messageBag)
    {
        $isTest = $this->isTest;

        error_reporting(E_ALL);
        ini_set('max_execution_time', 3600000);

        $images_url = [];

        $types = [
            'test' => [],
            'train' => []
        ];
        $files = [
            'test' => [],
            'train' => []
        ];
        $labels = [
            'test' => [],
            'train' => []
        ];

        $path = $this->path;
        $percent_of_training_data = (int)$this->percent_of_training_data;
        $expand = (int)$this->expand;


        $index = 1;
        $crop_index = 1;
        $test_index = 1;
        $train_index = 1;

        $train_index2 = 1;

        $image_prefix = setting_value('visiosoft.module.crop::image_path_prefix', '');


        $count_sql = DB::table('directory_management_label')
            ->selectRaw('count(id) as lSayi,category_id')
            ->whereIn('category_id', $this->options['types'])
            ->having('lSayi', '>=', $this->options['min_label_of_category'])
            ->groupBy('category_id')->get();

        $category_index = array_flip($this->options['types']);

        foreach ($count_sql as $row) {
            $category_group = $row->category_id;


            $query = DB::table('directory_management_label')
                ->selectRaw('default_directory_management_files.*,default_directory_management_type.*,default_directory_management_label.*,default_directory_management_files.id as file_unique_id,default_directory_management_type.id as type_unique_id,default_directory_management_label.id as label_unique_id,default_directory_management_type.name as type_name')
                ->leftJoin('directory_management_files', 'directory_management_label.file_id', 'directory_management_files.id')
                ->leftJoin('directory_management_type', 'directory_management_label.category_id', 'directory_management_type.id')
                ->where('directory_management_label.category_id', $category_group);

            if ($this->options['image_resolution']) {
                $select_resulation = explode('x', $this->options['image_resolution']);

                if (count($select_resulation) > 1) {
                    $query = $query->whereRaw('JSON_EXTRACT(size, "$.height") = ' . $select_resulation[0])// height resolution
                    ->whereRaw('JSON_EXTRACT(size, "$.width") = ' . $select_resulation[1]); // width resolution
                }
            }

            // IS Limit Exist
            if ($this->options['max_limit'] && $this->options['max_limit'] != 0) {
                $query = $query->limit($this->options['max_limit']);
            }

            $query = $query->get();

            $total_images = count($query);


            if ($isTest) {
                $test_percent = 10 - $percent_of_training_data;

                $test_count = round($total_images * $test_percent / 10);

                $test_per_image = ((int)$test_count == 0) ? 0 : floor($total_images / $test_count);

                $this->createFolder(__DIR__ . "/test");
            }

            $this->createFolder(__DIR__ . "/train");

            foreach ($query as $row) {

                $coordinates = json_decode($row->coordinates, true);
                $imagepath = $image_prefix . $row->path;
                $category = $row->name;
                $xmax = intval($coordinates['xmax']);
                $xmin = intval($coordinates['xmin']);
                $ymax = intval($coordinates['ymax']);
                $ymin = intval($coordinates['ymin']);

                if ($isTest && $train_index2 == $test_per_image) {
                    $file_new_folder = "test";
                    $test_index++;

                    $train_index2 = 0;
                } else {
                    $train_index++;

                    $train_index2++;

                    $file_new_folder = "train";
                }

                $index++;
                $crop_index++;
                $filename_without_ext = __DIR__ . "/" . $file_new_folder . "/" . $row->label_unique_id;

                $img_full_url = $filename_without_ext . ".jpeg";
                $xml_full_url = $filename_without_ext . ".xml";

                $xDifference = $xmax - $xmin;
                $yDifference = $ymax - $ymin;

                $error = false;

                if ($this->options['crop_image']) {
                    list($x_full_img, $y_full_img) = getimagesize($imagepath);

                    $distance_to_bottom = $y_full_img - $ymax;

                    $x_border_space = ($expand - $xDifference) / 2;
                    $y_border_space = ($expand - $yDifference) / 2;

                    $xMinWideImage = $xmin - $x_border_space;
                    $xMaxWideImage = $xmax + $x_border_space;

                    $x_max_xml = $x_border_space + $xDifference;
                    $x_min_xml = $x_border_space;

                    $y_min_xml = $y_border_space;
                    $y_max_xml = $y_border_space + $yDifference;

                    if ($xMinWideImage < 0) {
                        $xMaxWideImage = $xMaxWideImage + abs($xmin - $x_border_space);

                        $xMinWideImage = 0;

                        $x_max_xml = $xmax;
                        $x_min_xml = $xmin;
                    }

                    $pixelsNeededOnRight = ($x_full_img - $xmax) - $x_border_space;

                    if ($pixelsNeededOnRight < 0) {

                        $xMaxWideImage = $x_full_img;
                        $xMinWideImage = $xMinWideImage - abs($pixelsNeededOnRight);

                        $x_max_xml = $expand - ($x_full_img - $xmax);
                        $x_min_xml = $x_max_xml - $xDifference;
                    }

                    $yMinWideImage = $ymin - $y_border_space;
                    $yMaxWideImage = $ymax + $y_border_space;

                    if ($yMinWideImage < 0) {
                        $yMaxWideImage = $yMaxWideImage + abs($ymin - $y_border_space);
                        $yMinWideImage = 0;

                        $y_max_xml = $ymax;
                        $y_min_xml = $ymin;
                    }

                    $yPixelsNeededOnRight = ($y_full_img - $ymax) - $y_border_space;

                    if ($yPixelsNeededOnRight < 0) {
                        $yMaxWideImage = $y_full_img;
                        $yMinWideImage = $yMinWideImage - abs($yPixelsNeededOnRight);

                        $y_max_xml = $expand - ($y_full_img - $ymax);
                        $y_min_xml = $expand - ($distance_to_bottom + $yDifference);

                    }

                    if ($x_min_xml < 0 || $y_min_xml < 0 || $x_max_xml < 0 || $y_max_xml < 0) {
                        $error = true;

                        $messageBag->error(["This label is larger than width. #" . $row->label_unique_id]);
                    } else {
                        if ($this->options['crop_image']) {
                            $this->crop($xMinWideImage, $xMaxWideImage, $yMaxWideImage, $yMinWideImage, $img_full_url, $imagepath);
                        }
                    }

                } else {
                    $size = json_decode($row->size);

                    $x_full_img = $size->width;
                    $y_full_img = $size->height;
                }

                if (!$error) {
                    $segmentation_array = [];

                    $points = json_decode($row->points, true);

                    if (!is_array($points)) {
                        echo "This points data is faulty. Please remove it..";
                        dump($points, $row);
                        die;
                    }


                    foreach ($points as $segment_array_item) {
                        if (!is_array($segment_array_item)) {
                            $segment_array_item = [$segment_array_item];
                        }
                        $segmentation_array = array_merge($segmentation_array, $segment_array_item);
                    }

                    if (count($segmentation_array) < 5) {
                        continue;
                    }

                    $segmentation_array = [$segmentation_array];

                    $search_category = array_keys(array_combine(array_keys($types[$file_new_folder]), array_column($types[$file_new_folder], 'id')), $category_index[$row->type_unique_id] + 1);

                    if (!count($types[$file_new_folder])) {
                        $types[$file_new_folder][] = [
                            "supercategory" => null,
                            "id" => 0,
                            "name" => '__background__'
                        ];
                    }

                    if (count($search_category) < 1) {
                        $types[$file_new_folder][] = [
                            "supercategory" => null,
                            "id" => $category_index[$row->type_unique_id] + 1,
                            "name" => $row->type_name
                        ];
                    }

                    $search_image = array_keys(array_combine(array_keys($files[$file_new_folder]), array_column($files[$file_new_folder], 'id')), $row->file_unique_id);

                    if (count($search_image) < 1) {

                        $path_parts = pathinfo($row->url);

                        $images_url[$file_new_folder][$path_parts['filename']] = $image_prefix . $row->url;

                        $files[$file_new_folder][] = [
                            "license" => 2021,
                            "file_name" => $path_parts['basename'],
                            "coco_url" => $image_prefix . $row->url,//panorama resim url
                            "width" => ($this->options['crop_image']) ? $expand : $x_full_img,//croplu resim boyutu
                            "height" => ($this->options['crop_image']) ? $expand : $y_full_img,//croplu resim boyutu
                            "id" => $row->file_unique_id //file id
                        ];
                    }

                    if ($this->options['crop_image']) {
                        $bbox = [
                            round($x_min_xml, 0),
                            round($y_min_xml, 0),
                            round($x_max_xml, 0) - round($x_min_xml, 0),
                            round($y_max_xml, 0) - round($y_min_xml, 0)
                        ];
                    }

                    $bbox_org_array = json_decode($row->bbox, true);

                    $bbox_org_x = (round($bbox_org_array['x'], 0) < 1) ? 1 : round($bbox_org_array['x'], 0); // 1'den küçük ise 1 al
                    $bbox_org_y = (round($bbox_org_array['y'], 0) < 1) ? 1 : round($bbox_org_array['y'], 0); // 1'den küçük ise 1 al
                    $bbox_org_width = (($bbox_org_x + round($bbox_org_array['width'], 0)) > $x_full_img) ? ($x_full_img - $bbox_org_x) : round($bbox_org_array['width'], 0); // resim genişliğinden büyük ise resim genişliğini sınır al
                    $bbox_org_height = (($bbox_org_y + round($bbox_org_array['height'], 0)) > $y_full_img) ? ($y_full_img - $bbox_org_y) : round($bbox_org_array['height'], 0); // resim yüksekliğinden büyük ise resim yüksekliğini sınır al

                    $bbox_org = [
                        $bbox_org_x,
                        $bbox_org_y,
                        $bbox_org_width,
                        $bbox_org_height
                    ];

                    $labels[$file_new_folder][] = [
                        "segmentation" => $segmentation_array,
                        "area" => ($this->options['crop_image']) ? (round($y_min_xml, 0) * round($x_max_xml, 0)) : ($bbox_org[2] * $bbox_org[3]),
                        "iscrowd" => 0,
                        "image_id" => $row->file_unique_id,
                        "bbox" => ($this->options['crop_image']) ? $bbox : $bbox_org,
                        "category_id" => $category_index[$row->type_unique_id] + 1,
                        "id" => $row->label_unique_id
                    ];
                }

                if ($this->options['create_xml']) {
                    $xml = new \SimpleXMLElement('<annotation/>');

                    $xml->addChild('folder', $file_new_folder);
                    $xml->addChild('filename', $crop_index . ".jpeg");
                    $xml->addChild('path', $path . $file_new_folder . "\\" . $crop_index . ".jpeg");

                    $size = $xml->addChild('size', "");
                    $size->addChild("width", $expand);
                    $size->addChild("height", $expand);
                    $size->addChild("depth", 3);

                    $source = $xml->addChild('source', "");
                    $source->addChild('database', "Unknown");

                    $new_object = $xml->addChild('object');
                    $new_object->addChild('name', $category);
                    $new_object->addChild('pose', 'Unspecified');
                    $new_object->addChild('truncated', 0);
                    $new_object->addChild('difficult', 0);
                    $bndbox = $new_object->addChild('bndbox');
                    $bndbox->addChild('xmin', round($x_min_xml, 0));
                    $bndbox->addChild('ymin', round($y_min_xml, 0));
                    $bndbox->addChild('xmax', round($x_max_xml, 0));
                    $bndbox->addChild('ymax', round($y_max_xml, 0));


                    if (!$error) {
                        $xml->asXML($xml_full_url);
                    }
                }
            }
        }

        $status = $this->buildJSON($types, $labels, $files);

        if ($this->options['download_image']) {
            $this->buildImages($images_url);
        }

        if ($status) {
            $filename = "configuration-" . date('Y-m-d-H-i-s') . ".zip";
            $this->buildZip($filename);

            echo "\n Download Link =>  https://labelserver.mapilio.com/" . $filename . "\n";

            return $filename;
        } else {
            return "couldn't write to file. Perhaps permissions?";
        }
    }

    function crop($xmin, $xmax, $ymax, $ymin, $dist, $url, $text = "")
    {
        $im = imagecreatefromjpeg($url);

        $height = $ymax - $ymin;
        $width = $xmax - $xmin;

        $im2 = imagecrop($im, ['x' => $xmin, 'y' => $ymin, 'width' => $width, 'height' => $height]);

        if ($im2 !== FALSE) {

            if ($text != "") {
                $white = imagecolorallocate($im2, 255, 255, 255);
                $font = __DIR__ . "/assets/arial.ttf";

                $height = imagesy($im2);

                $text_size = imagettfbbox(12, 0, $font, $text);
                $text_height = max([$text_size[5], $text_size[7]]) - min([$text_size[1], $text_size[3]]);

                $centerX = CEIL(($height - $text_height) / 2);
                $centerY = $centerX < 0 ? 0 : $centerX;
                imagettftext($im2, 12, 0, $centerX, $centerY, $white, $font, $text);
            }

            imagejpeg($im2, $dist);
            imagedestroy($im2);
        }
        imagedestroy($im);
    }

    function createFolder($p)
    {
        if (!file_exists($p)) {
            mkdir($p, 0777, true);
        }
    }

    public function buildJSON(array $types, array $labels, array $files)
    {
        $status = false;

        if (count($labels['test'])) {
            $status = true;

            $test = [
                "info" => [
                    "description" => "Coco Json Format",
                    "url" => "http://mapilio.com/",
                    "version" => 0.2,
                    "year" => "None",
                    "contributer" => "mapilio (c)",
                    "data_created" => "None"
                ],
                "licenses" => [
                    [
                        "url" => "https://visiosoft.com.tr/",
                        "id" => 0,
                        "name" => "Visiosoft"
                    ]
                ],
                "type" => "instances",
                "categories" => $types['test'],
                "images" => $files['test'],
                "annotations" => $labels['test']
            ];


            //save test
            $fp = fopen(__DIR__ . "/test/build.json", 'w');
            fwrite($fp, json_encode($test, JSON_UNESCAPED_UNICODE));
            fclose($fp);
        }

        if (count($labels['train'])) {
            $status = true;

            $train = [
                "info" => [
                    "description" => "Coco Json Format",
                    "url" => "http://mapilio.com/",
                    "version" => 0.2,
                    "year" => "None",
                    "contributer" => "mapilio (c)",
                    "data_created" => "None"
                ],
                "licenses" => [
                    [
                        "url" => "https://visiosoft.com.tr/",
                        "id" => 0,
                        "name" => "Visiosoft"
                    ]
                ],
                "type" => "instances",
                "categories" => $types['train'],
                "images" => $files['train'],
                "annotations" => $labels['train']
            ];

            //save train
            $fp = fopen(__DIR__ . "/train/build.json", 'w');
            fwrite($fp, json_encode($train, JSON_UNESCAPED_UNICODE));
            fclose($fp);
        }

        return $status;
    }

    public function buildZip($filename)
    {
        $zip = new \ZipArchive;
        if ($zip->open($filename, \ZipArchive::CREATE) === TRUE) {

            foreach (scandir(__DIR__ . "/train/") as $entry) {
                if ($entry != "." && $entry != "..") {
                    $zip->addFromString('train/' . $entry, file_get_contents(__DIR__ . "/train/" . $entry));
                }
            }
            if ($this->isTest) {
                foreach (scandir(__DIR__ . "/test/") as $entry) {
                    if ($entry != "." && $entry != "..") {
                        $zip->addFromString('test/' . $entry, file_get_contents(__DIR__ . "/test/" . $entry));
                    }
                }
                (new Filesystem)->remove(__DIR__ . "/test");
            }


            (new Filesystem)->remove(__DIR__ . "/train");

            $zip->close();


            if (!copy($filename, 'public/' . $filename)) {
                echo "\nCould not copy $filename to public directory...\n";
            }
        }
    }

    public function buildImages($images_url)
    {
        $total = $this->isTest ? (count($images_url['test']) + count($images_url['train'])) : count($images_url['train']);
        $index = 1;

        if ($this->isTest) {
            echo "Total Images = " . $total . "  |  Total Test = " . count($images_url['test']) . "  |  Total Train = " . count($images_url['train']);
        } else {
            echo "Total Images = " . $total . "  |  Total Train = " . count($images_url['train']);
        }
        echo "\n----------------------------------------------\n";
        foreach ($images_url as $type_name => $type) {
            foreach ($type as $image_name => $image_url) {

                echo "#" . $index . "    ";
                $this->save_image($image_url, __DIR__ . '/' . $type_name . '/' . $image_name . '.jpeg');
                $index++;
            }
        }
    }

    public function save_image($inPath, $outPath)
    {
        $opts = array(
            "ssl" => array(
                "verify_peer" => false,
                "verify_peer_name" => false,
            ),
        );

        $in = fopen($inPath, "rb", false, stream_context_create($opts));
        $out = fopen($outPath, "wb");
        while ($chunk = fread($in, 8192)) {
            fwrite($out, $chunk, 8192);
        }
        fclose($in);
        fclose($out);

        echo "Downloaded ---=> " . $inPath . "\n";
    }
}
