<?php namespace Visiosoft\CropModule\Cropper\Form;

use Visiosoft\CropModule\Cropper\Contract\CropperRepositoryInterface;

class CropperFormHandler
{
    public function handle(CropperFormBuilder $builder, CropperRepositoryInterface $repository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $options = [
            'types' => $builder->getPostValue('categories'),
            'min_label_of_category' => $builder->getPostValue('min_label_of_category'),
            'debug' => $builder->getPostValue('debug'),
            'max_limit' => $builder->getPostValue('max_limit'),
        ];

        $filename = dispatch_now(new BuildJSON($builder->getPostValue('path'), $builder->getPostValue('percent_of_training_data'), $builder->getPostValue('genislet'), $options));

        if ($filename) {
            $repository->newQuery()->create(['filename' => $filename, 'types' => json_encode($builder->getPostValue('categories'))]);
        }
    }
}
