<?php
namespace Visiosoft\CropModule\Console\Commands;


use Illuminate\Console\Command;
use Visiosoft\CropModule\Cropper\Form\BuildJSON;

class Run extends Command
{

	protected $signature = 'run {percent} {pixel} {catid}';

	protected $description = "run like: {percent} {pixel} {catid} :> 8 512 47";

	public function __construct()
	{
		parent::__construct();
	}

	public function handle()
	{
        $this->info('Started cropping...');

        $options = [
            'types' => array($this->argument('catid')),
            'min_label_of_category' => 0,
            'debug' => false,
            'max_limit' => 999999,
        ];

        $filename = dispatch_now(new BuildJSON("",
                                            $this->argument('percent'),
                                            $this->argument('pixel'),
                                            $options
                                        ));
        $this->info($filename);
        $this->info("Process finished");
    }
}