<?php namespace Visiosoft\CropModule\Cropper\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visio\DirectoryManagementModule\Type\Contract\TypeRepositoryInterface;

class CropperTableColumns
{
    public function handle(CropperTableBuilder $builder)
    {
        $builder->setColumns([
            'id' => [
                'value' => '{entry.id}'
            ],
            'filename',
            'categories' => [
                'value' => function (EntryInterface $entry, TypeRepositoryInterface $typeRepository) {
                    $array = json_decode($entry->types,true);

                    $names = $typeRepository->newQuery()->whereIn('id',$array)->get()->pluck('name','id')->all();

                    return implode(' , ',$names);
                }
            ],
        ]);
    }
}
