<?php

namespace Visiosoft\CrmModule\Listeners;

use Visiosoft\ApiGooglecontactsExtension\Event\ContactsReceivedEvent;
use Visiosoft\CrmModule\Customer\Contract\CustomerRepositoryInterface;

class GoogleContactsReceivedListener
{
    public function handle(ContactsReceivedEvent $contactsReceivedEvent)
    {
        $customerRepository = app(CustomerRepositoryInterface::class);
        foreach ($contactsReceivedEvent->getContacts() as $contact) {
            $customer = $customerRepository->findBy('phone', $contact->getPhone());
            if (!$customer) {
                $customerParams = [
                    'name' => $contact->getName(),
                    'email' => $contact->getEmail(),
                    'phone' => $contact->getPhone()
                ];
                $customerRepository->create($customerParams);
            }
        }

    }
}