<?php namespace Visiosoft\CrmModule\Appointment;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\CrmModule\Appointment\Contract\AppointmentInterface;
use Anomaly\Streams\Platform\Model\Crm\CrmAppointmentsEntryModel;
use Visiosoft\CrmModule\Customer\CustomerModel;
use Visiosoft\CrmModule\Deal\DealModel;

class AppointmentModel extends CrmAppointmentsEntryModel implements AppointmentInterface
{
    protected $appends = ['appointment_status'];

    public function getAppointmentStatusAttribute()
    {
        if ($this->appointment_date >= date("Y-m-d H:i:s")) {
            return "new";
        } else {
            return "old";
        }
    }

    public function salesman()
    {
        return $this->hasOne(UserModel::class, 'id', 'salesman_id');
    }

    public function deal()
    {
        return $this->hasOne(DealModel::class, 'id', 'salesman_id');
    }

    public function customer()
    {
        return $this->hasOne(CustomerModel::class, 'id', 'salesman_id');
    }
}
