<?php namespace Visiosoft\CrmModule\DealItem;

use Visiosoft\CrmModule\DealItem\Contract\DealItemInterface;
use Anomaly\Streams\Platform\Model\Crm\CrmDealItemsEntryModel;
use Visiosoft\CrmModule\Item\ItemModel;

class DealItemModel extends CrmDealItemsEntryModel implements DealItemInterface
{
    protected $appends = 'total_price';

    public function item()
    {
        return $this->belongsTo(ItemModel::class);
    }

    public function getTotalPriceAttribute()
    {
        return $this->quantity * $this->amount;
    }
}
