<?php namespace Visiosoft\CrmModule\Customer;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Models\Activity;
use Visiosoft\CrmModule\Models\ActivityString;
use Visiosoft\CrmModule\Models\ActivityTypes;

class CustomerObserver extends EntryObserver
{
    private $activityRepository;

    public function __construct()
    {
        $this->activityRepository = app(ActivityRepositoryInterface::class);
        parent::__construct();
    }


    public function created(EntryInterface $entry)
    {
        $activityTranslate = new ActivityString('visiosoft.module.crm::activity.customer_created');
        $this->activityRepository->createActivity(new Activity($activityTranslate, $entry->id, $entry->id), new ActivityTypes('CUSTOMER'));

    }

    public function updated(EntryInterface $entry)
    {
        $activityTranslate = new ActivityString('visiosoft.module.crm::activity.customer_updated', ['no'], [$entry->id]);
        $activity = new Activity($activityTranslate, $entry->id, $entry->id);
        $activity->setOldData($entry->getOriginal());
        $activity->setNewData($entry->getDirty());

        $this->activityRepository->createActivity($activity, new ActivityTypes('CUSTOMER'));

    }
}