<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCrmCreateCustomersStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'customers',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];


    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'email' => 'anomaly.field_type.text',
        'phone' => 'anomaly.field_type.text',
        'address' => 'anomaly.field_type.text',
        'lat' => 'anomaly.field_type.text',
        'lng' => 'anomaly.field_type.text',
        'additional_info' => 'anomaly.field_type.textarea'
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'required' => true,
        ],
        'email',
        'phone',
        'address',
        'lat',
        'lng',
        'additional_info'
    ];

}
