<?php namespace Visiosoft\CrmModule\DealType;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CrmModule\DealType\Contract\DealTypeRepositoryInterface;

class DealTypeSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(DealTypeRepositoryInterface $dealTypeRepository)
    {
        $entries = [
            [
                'en' => [
                    'name' => 'Physical Product Sale'
                ],
                'tr' => [
                    'name' => "Fiziksel Ürün Satışı"
                ],
                'slug' => 'physical_product_sale'
            ],
            [
                'en' => [
                    'name' => 'Digital Product Sale'
                ],
                'tr' => [
                    'name' => "Dijital Ürün Satışı"
                ],
                'slug' => 'digital_product_sale'
            ],
        ];

        foreach ($entries as $entry) {
            if (!$dealTypeRepository->newQuery()->where('slug', $entry['slug'])->first()) {
                $dealTypeRepository->newQuery()->create($entry);
            }
        }
    }
}
