<?php namespace Visiosoft\CrmModule\Deal;

use Anomaly\UsersModule\User\UserModel;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Visiosoft\CrmModule\Deal\Contract\DealInterface;
use Anomaly\Streams\Platform\Model\Crm\CrmDealsEntryModel;
use Visiosoft\CrmModule\DealItem\DealItemModel;
use Visiosoft\CrmModule\Note\NoteModel;

class DealModel extends CrmDealsEntryModel implements DealInterface
{
    public function salesman()
    {
        return $this->hasOne(UserModel::class, 'id', 'salesman_id');
    }

    public function items(): HasMany
    {
        return $this->hasMany(DealItemModel::class, 'deal_id')->orderBy('id','DESC');
    }

    public function notes(): HasMany{
        return $this->hasMany(NoteModel::class, 'deal_id');
    }

}
