<?php namespace Visiosoft\CrmModule\Activity;

use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\CrmModule\Models\Activity;
use Visiosoft\CrmModule\Models\ActivityTypes;

class ActivityRepository extends EntryRepository implements ActivityRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ActivityModel
     */
    protected $model;

    /**
     * Create a new ActivityRepository instance.
     *
     * @param ActivityModel $model
     */
    public function __construct(ActivityModel $model)
    {
        $this->model = $model;
    }

    public function createActivity(Activity $activity, ActivityTypes $activityType)
    {
        $params = [
            'activity' => $activity->getActivity(),
            'type' => $activityType->getValue(),
            'related_id' => $activity->getRelatedID(),
            'user_id' => $activity->getUserID()
        ];

        return $this->model->newQuery()->create($params);
    }

    public function getActivitiesWithFilters(ActivityFilters $filters)
    {
        $query = $this->model->with('user');

        if ($filters->getUser()) {
            $query->where('user_id', $filters->getUser());
        }

        if ($filters->getStartedAt()) {
            $query->where('created_at', '>=', $filters->getStartedAt());
        }

        if ($filters->getEndedAt()) {
            $query->where('created_at', '<=', $filters->getEndedAt());
        }
        return $query->orderBy('created_at', 'DESC')->get();
    }

}
