<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCrmAddSalesmanIdToCustomers extends Migration
{

    protected $stream = [
        'slug' => 'customers'
    ];

    protected $fields = [
        'salesman' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Anomaly\UsersModule\User\UserModel::class,
                'mode' => "lookup"
            ]
        ],
        'deal_stage' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\DealStage\DealStageModel::class
            ]
        ]
    ];

    protected $assignments = [
        'salesman',
        'deal_stage'
    ];
}
