<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\CrmModule\Deal\DealModel;
use Visiosoft\CrmModule\Item\ItemModel;

class VisiosoftModuleCrmCreateDealItemsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'deal_items',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'deal' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => DealModel::class,
                'type' => "lookup"
            ]
        ],
        'item' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => ItemModel::class
            ]
        ],
        'quantity' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 0
            ]
        ],
        'unit_price' => [
            'type' => 'anomaly.field_type.decimal',
            'config' => [
                'default_value' => 0
            ]
        ]
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'deal' => [
            'required' => true,
        ],
        'item' => [
            'required' => true,
        ],
        'quantity',
        'unit_price'
    ];

}
