<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCrmCreateAppointmentsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'appointments',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => "anomaly.field_type.text",
        'note' => "anomaly.field_type.textarea",
        'salesman' => [
            'type' => "anomaly.field_type.relationship",
            'config' => [
                'related' => Anomaly\UsersModule\User\UserModel::class,
                'mode' => "lookup"
            ]
        ],
        'customer' => [
            'type' => "anomaly.field_type.relationship",
            'config' => [
                'related' => Visiosoft\CrmModule\Customer\CustomerModel::class,
                'mode' => "lookup"
            ]
        ],
        'deal' => [
            'type' => "anomaly.field_type.relationship",
            'config' => [
                'related' => Visiosoft\CrmModule\Deal\DealModel::class,
                'mode' => "lookup"
            ]
        ],
        'appointment_date' => "anomaly.field_type.datetime"

    ];


    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'required' => true,
        ],
        'note',
        'salesman' => [
            'required' => true,
        ],
        'customer',
        'deal',
        'appointment_date' => [
            'required' => true,
        ],
    ];

}
