<?php namespace Visiosoft\CrmModule\DealStage;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CrmModule\DealStage\Contract\DealStageRepositoryInterface;

class DealStageSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(DealStageRepositoryInterface $dealStageRepository)
    {
        $entries = [
            [
                'en' => [
                    'name' => 'Scheduled Appointment'
                ],
                'tr' => [
                    'name' => "Planlanmış Randevu"
                ],
                'slug' => 'scheduled_appointment'
            ],
            [
                'en' => [
                    'name' => 'At The Decision Stage'
                ],
                'tr' => [
                    'name' => "Karar Aşamasında"
                ],
                'slug' => 'at_the_decision_stage'
            ],
            [
                'en' => [
                    'name' => 'Offer / Contract Sended'
                ],
                'tr' => [
                    'name' => "Teklif - Sözleşme Gönderildi"
                ],
                'slug' => 'offer_sended'
            ],
            [
                'en' => [
                    'name' => 'Deal Agreed'
                ],
                'tr' => [
                    'name' => "Anlaşma Sağlandı"
                ],
                'slug' => 'deal_agreed'
            ],
            [
                'en' => [
                    'name' => 'Presentation Sent'
                ],
                'tr' => [
                    'name' => "Sunum Gönderildi"
                ],
                'slug' => 'presentation_sent'
            ],
            [
                'en' => [
                    'name' => 'Potential Customer'
                ],
                'tr' => [
                    'name' => "Potansiyel Müşteri"
                ],
                'slug' => 'potential_customer'
            ],
        ];

        foreach ($entries as $entry) {
            if (!$dealStageRepository->newQuery()->where('slug', $entry['slug'])->first()) {
                $dealStageRepository->newQuery()->create($entry);
            }
        }

    }
}
