<?php namespace Visiosoft\CrmModule\Priority;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CrmModule\Priority\Contract\PriorityRepositoryInterface;

class PrioritySeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(PriorityRepositoryInterface $priorityRepository)
    {
        $entries = [
            [
                'en' => [
                    'name' => 'Low'
                ],
                'tr' => [
                    'name' => "Düşük"
                ],
                'slug' => 'low'
            ],
            [
                'en' => [
                    'name' => 'Medium'
                ],
                'tr' => [
                    'name' => "Orta"
                ],
                'slug' => 'medium'
            ],
            [
                'en' => [
                    'name' => 'High'
                ],
                'tr' => [
                    'name' => "Yüksek"
                ],
                'slug' => 'high'
            ],
        ];

        foreach ($entries as $entry) {
            if (!$priorityRepository->newQuery()->where('slug', $entry['slug'])->first()) {
                $priorityRepository->newQuery()->create($entry);
            }
        }
    }
}
