<?php namespace Visiosoft\CrmModule\Note;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Models\Activity;
use Visiosoft\CrmModule\Models\ActivityString;
use Visiosoft\CrmModule\Models\ActivityTypes;

class NoteObserver extends EntryObserver
{
    private $activityRepository;

    public function __construct()
    {
        $this->activityRepository = app(ActivityRepositoryInterface::class);
        parent::__construct();
    }

    public function created(EntryInterface $entry)
    {
        $activityTranslate = new ActivityString('visiosoft.module.crm::activity.note_created', ['no', 'note'], [$entry->id, $entry->content]);
        $this->activityRepository->createActivity(new Activity($activityTranslate, $entry->id, $entry->customer_id), new ActivityTypes('CUSTOMER'));
    }
}