<?php namespace Visiosoft\CrmModule\Deal;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Models\Activity;
use Visiosoft\CrmModule\Models\ActivityString;
use Visiosoft\CrmModule\Models\ActivityTypes;

class DealObserver extends EntryObserver
{
    private $activityRepository;

    public function __construct()
    {
        $this->activityRepository = app(ActivityRepositoryInterface::class);
        parent::__construct();
    }


    public function created(EntryInterface $entry)
    {
        $activityTranslate = new ActivityString('visiosoft.module.crm::activity.deal_created', ['name'], [$entry->name]);
        $this->activityRepository->createActivity(new Activity($activityTranslate, $entry->id, $entry->customer_id), new ActivityTypes('CUSTOMER'));

    }

    public function updated(EntryInterface $entry)
    {
        $activityTranslate = new ActivityString('visiosoft.module.crm::activity.deal_updated', ['no'], [$entry->id]);
        $activity = new Activity($activityTranslate, $entry->id, $entry->customer_id);
        $activity->setOldData($entry->getOriginal());
        $activity->setNewData($entry->getDirty(), ['name', 'amount']);

        $this->activityRepository->createActivity($activity, new ActivityTypes('CUSTOMER'));

    }
}