<?php namespace Visiosoft\CrmModule\Customer;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Visiosoft\CrmModule\Activity\ActivityModel;
use Visiosoft\CrmModule\Appointment\AppointmentModel;
use Visiosoft\CrmModule\Customer\Contract\CustomerInterface;
use Anomaly\Streams\Platform\Model\Crm\CrmCustomersEntryModel;
use Visiosoft\CrmModule\Deal\DealModel;
use Visiosoft\CrmModule\Note\NoteModel;

class CustomerModel extends CrmCustomersEntryModel implements CustomerInterface
{
    public function notes(): HasMany
    {
        return $this->hasMany(NoteModel::class, 'customer_id')->orderBy('id', 'DESC');
    }

    public function appointments(): HasMany
    {
        return $this->hasMany(AppointmentModel::class, 'customer_id')->orderBy('id', 'DESC');
    }

    public function deals(): HasMany
    {
        return $this->hasMany(DealModel::class, 'customer_id')->orderBy('id', 'DESC');
    }

    public function activities(): HasMany
    {
        return $this->hasMany(ActivityModel::class, 'related_id')->orderBy('id', 'DESC');
    }
}
