<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCrmCreateDealsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'deals',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => true,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => "anomaly.field_type.text",
        'deal_type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\DealType\DealTypeModel::class
            ]
        ],
        'deal_stage' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\DealStage\DealStageModel::class
            ]
        ],
        'priority' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\Priority\PriorityModel::class
            ]
        ],
        'salesman' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Anomaly\UsersModule\User\UserModel::class,
                'mode' => "lookup"
            ]
        ],
        'customer' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\Customer\CustomerModel::class,
                'mode' => "lookup"
            ]
        ],
        'amount' => 'anomaly.field_type.decimal',
        'expire_date' => "anomaly.field_type.datetime"
    ];


    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'required' => true,
        ],
        'deal_type' => [
            'required' => true,
        ],
        'deal_stage' => [
            'required' => true,
        ],
        'priority',
        'salesman',
        'customer',
        'amount',
        'expire_date'

    ];

}
